ORCA/M Asm65816 2.1.0

0001 4352                       Blanks off 
0002 4352                       String asis 
0003 4352
0004 4352                       TITLE 'Apple IIGS Window Manager                   DOCDEF.ASM' 
0005 4352              ;
0006 4352              ;          Copyright Apple Computer, Inc. 1986
0007 4352              ;          All rights reserved
0008 4352              ;          Written by Dan Oliver
0009 4352              ;
0010 4352              ;        This module contains the window definition procedure
0011 4352              ;        of a standard square cornered window.  The window can
0012 4352              ;        have, title bar with a close and/or zoom box, information
0013 4352              ;        bar, vertical scroll bar, horizontal scroll bar drop shadow,
0014 4352              ;        grow box or just a frame.
0015 4352              ;
0016 4352              ;
0017 4352              ; Files needed:
0018 4352              ;          DOCDEF.ASM
0019 4352              ;            DEF.MACROS
0020 4352              ;          DOCCALL.ASM
0021 4352              ;          ALERTDEF.ASM
0022 4352              ;          DEFUTIL.ASM
0023 4352              ;          DDATA.ASM
0024 4352              ;
0025 4352              ; Change history:
0026 4352              ;
0027 4352              ; 07/18/88  Dan O.  Changed hSetTitle to draw info bar in addition to the title bar because versions
0028 4352              ;                   of the Window Manager on System Disks 3.1 and before redrew the entire frame
0029 4352              ;                   when the title changed.  The application "List Plus" depended on the info bar
0030 4352              ;                   being redrawn when the title was changed.
0031 4352              ;
0032 4352              ; 08/08/88  Dan O.  I had (a while ago) removed masking the scroll bar thumb position in TaskScroll
0033 4352              ;                   with the window's origin mask.  I've now put that back in.  This means that
0034 4352              ;                   sometimes the thumb may not go all the way to the right side (horizontal scroll
0035 4352              ;                   bars).
0036 4352              ;
0037 4352              ; 10/28/88  Dan O.  Close window free's title and color table if they're a handle.
0038 4352              ;                   DefProcs also handle titles and color tables as pointers or handles.
0039 4352              ;                   Change set title and color table to dispose of exsisting handles first.
0040 4352
0041 4352              ;
0042 4352              ; 21 May 89         Steven Glass
0043 4352              ;
0044 4352              ; Minor change to new origin to prevent the orphaning of regions during
0045 4352              ; scrolling.
0046 4352              ;
0047 4352              ; 27-Sep-90         Dave Lyons
0048 4352              ;
0049 4352              ; Changes to use Get640Colors instead of hard-coding our own solid-color
0050 4352              ; table.
0051 4352              ;
0052 4352              ; 14-Nov-90         Dave Lyons
0053 4352              ;
0054 4352              ; Fixed memory-trashing bug in unlockColor (the two words of the color table handle
0055 4352              ; were reversed, so we were turning off bit 15 of a semi-random location).
0056 4352              ; See separate fix in WCtlDef.asm's own unlockColor subroutine.
0057 4352              ; (This bug means that Window Color Table Resources can't be used reliably in
0058 4352              ; System 5.0 through 5.0.3.)
0059 4352              ;
0060 4352
0061 4352                       INCLUDE 'ALL.MACROS' 
0062 4352                       include 'WindMgrEquates.asm' 
0063 4352
0064 4352
0065 4352
0066 4352              ;
0067 4352              ; --- DefProc direct page offsets ----------------------------
0068 4352              ;
0069 4352              windColors equ   1                      Pointer to window's color table.
0070 4352              w_wrect  equ   windColors+4             Bounds of window's strucRgn.
0071 4352              w_rect   equ   w_wrect+8                General RECT area.
0072 4352              w_work   equ   w_rect+8                 w_work space.
0073 4352              DIRECTSIZE equ   w_work+37              Size of allocated direct page.
0074 4352              saveDpage equ   DIRECTSIZE+1            Caller's direct page.
0075 4352              returnAddr equ   saveDpage+2            Long return addresses.
0076 4352              w_param  equ   returnAddr+3             Parameter defined by defProc operation.
0077 4352              w_wind   equ   w_param+4                Pointer to window record.
0078 4352              operation equ   w_wind+4                DefProc operation to perform.
0079 4352              globals  equ   operation+2              Pointer to Window Manager globals.
0080 4352              result   equ   globals+4                Result defined by defProc operation.
0081 4352              ;
0082 4352              ;
0083 4352              ;
0084 4352              ; --- wCallDefProc parameter list offsets --------------------
0085 4352              ;
0086 4352              dRequest equ   0
0087 4352              defProcID equ   dRequest+2
0088 4352              newParam equ   defProcID+2
0089 4352              ;
0090 4352              ;
0091 4352              ; --- Document window record offsets -------------------------
0092 4352              ;
0093 4352              wtitle   equ   212                      212 Pointer to window's title.
0094 4352              wtitle_w equ   wtitle+4                 216 Width of title in pixels.
0095 4352              worgn_mask equ   wtitle_w+2             218 Mask for horizontal origin.
0096 4352              wfull    equ   worgn_mask+2             220 Size of window, used with ZoomWindow.
0097 4352              wcolor   equ   wfull+8                  228 Pointer to window's color table.
0098 4352              y_origin equ   wcolor+4                 232 Content's vertical offset.
0099 4352              x_origin equ   y_origin+2               234 Content's horizontal offset.
0100 4352              data_h   equ   x_origin+2               236 Height of total data area.
0101 4352              data_w   equ   data_h+2                 238 Width of total data area.
0102 4352              wmaxheight equ   data_w+2               240 Maximum height for grow window.
0103 4352              wmaxwidth equ   wmaxheight+2            242 Maximum width for grow window.
0104 4352              vscroll  equ   wmaxwidth+2              244 Amount to scroll vertically (arrows).
0105 4352              hscroll  equ   vscroll+2                246 Amount to scroll horizonally (arrows).
0106 4352              vpage    equ   hscroll+2                248 Amount to page vertically (page region).
0107 4352              hpage    equ   vpage+2                  250 Amount to page horizontally (page rgn).
0108 4352              wInfoRef equ   hpage+2                  252 Value passed to Draw Info routine.
0109 4352              wInfoHeight equ   wInfoRef+4            256 Height of information bar.
0110 4352              woldYOrg equ   wInfoHeight+2            258 Save y origin on full window.
0111 4352              woldXOrg equ   woldYOrg+2               260 Save x origin on full window.
0112 4352              wInfoDraw equ   woldXOrg+2              262 Address of routine to draw Info Bar.
0113 4352              DOCSIZE  equ   wInfoDraw+4              266 Size of document window record.
0114 4352              ;
0115 4352              ;
0116 4352              ; --- New window parameter list offsets ----------------------------
0117 4352              ;
0118 4352              p_length equ   0                        Number of bytes in parameter list.
0119 4352              p_wframe equ   p_length+2               Type of window, frame flags.
0120 4352              p_wtitle equ   p_wframe+2               Pointer to window's title.
0121 4352              p_wrefCon equ   p_wtitle+4              Reserved for application.
0122 4352              p_wfull  equ   p_wrefCon+4              Size of window, used with ZoomWindow.
0123 4352              p_wcolor equ   p_wfull+8                Pointer to window's color table.
0124 4352              p_y_origin equ   p_wcolor+4             Content's vertical offset.
0125 4352              p_x_origin equ   p_y_origin+2           Content's horizontal offset.
0126 4352              p_data_h equ   p_x_origin+2             Height of total data area.
0127 4352              p_data_w equ   p_data_h+2               Width of total data area.
0128 4352              p_wmaxheight equ   p_data_w+2
0129 4352              p_wmaxwidth equ   p_wmaxheight+2
0130 4352              p_vscroll equ   p_wmaxwidth+2           Amount to scroll vertically (arrows).
0131 4352              p_hscroll equ   p_vscroll+2             Amount to scroll horizonally (arrows).
0132 4352              p_vpage  equ   p_hscroll+2              Amount to page vertically (page region).
0133 4352              p_hpage  equ   p_vpage+2                Amount to page horizontally (page rgn).
0134 4352              p_wInfoText equ   p_hpage+2
0135 4352              p_wInfoH equ   p_wInfoText+4            Height of infomation bar.
0136 4352              p_wdefProc equ   p_wInfoH+2             NOT USED.
0137 4352              p_wInfoDraw equ   p_wdefProc+4          Address of routine to draw Info Bar.
0138 4352              p_updateDraw equ   p_wInfoDraw+4        Address of routine to draw content region.
0139 4352              p_position equ   p_updateDraw+4
0140 4352              p_behind equ   p_position+8
0141 4352              p_windrec equ   p_behind+4
0142 4352              p_size   equ   p_windrec+4
0143 4352              ;
0144 4352              ;
0145 4352              ; --- Window DefProc frame offsets -----------------------------
0146 4352              ;
0147 4352              TITLEH   equ   13                       Height of title bar.
0148 4352              TITLEL   equ   2                        Space on left and right of title bar pattern.
0149 4352              TITLET   equ   3                        Space on top and bottom of title bar pattern.
0150 4352              ;
0151 4352              CLOSEL   equ   10                       Left side of window to left side of close box.
0152 4352              CLOSET   equ   2                        Top of window to top of close box.
0153 4352              CLOSEW   equ   22                       Width of close box.
0154 4352              CLOSEH   equ   11                       Height of close box.
0155 4352              ;
0156 4352              ;
0157 4352              ; --- Window color table offsets -----------------------------
0158 4352              ;
0159 4352              FRAME_CLR equ   0                       Frame's outline.
0160 4352              TITLE_CLR equ   FRAME_CLR+2             Title's color.
0161 4352              BAR_CLR  equ   TITLE_CLR+2              Title bar's initerior.
0162 4352              GROW_CLR equ   BAR_CLR+2                Grow box interior.
0163 4352              INFOR_CLR equ   GROW_CLR+2              Information bar interior.
0164 4352              COLORSIZ equ   INFOR_CLR+2              Size of color table.
0165 4352              ;
0166 4352              ;
0167 4352              ; --- Offsets into GrafPort
0168 4352              ;
0169 4352              boundsRect EQU   $08                    ; Rect - LocInfo - BoundsRect
0170 4352              clipRgn  EQU   $18                      ; RgnHandle - GrafPort - Clip Rgn. Pointer
0171 4352              visRgn   EQU   $1C                      ; RgnHandle - GrafPort - Vis. Rgn. Pointer
0172 4352
0173 4352              ;
0174 4352              ;
0175 4352              ; --- Part codes for standard controls -----------------
0176 4352              ;
0177 4352              ;
0178 4352              titlePart equ   16
0179 4352              closePart equ   17
0180 4352              zoomPart equ   18
0181 4352              infoPart equ   19
0182 4352              ;
0183 4352              ;
0184 4352              ; --- IDs of window frame controls ---------------------------
0185 4352              ;
0186 4352              titleBarID equ   0
0187 4352              infoBarID equ   2
0188 4352              VScrollID equ   4
0189 4352              HScrollID equ   6
0190 4352              GrowID   equ   8
0191 4352              ;
0192 4352
0193 4352
0194 4352              ;-----------------------------------------------
0195 4352              ;
0196 4352              ;   Imported addresses
0197 4352              ;
0198 4352              ;-----------------------------------------------
0199 4352
0200 4352                       IMPORT Allocate 
0201 4352                       IMPORT Bring 
0202 4352                       IMPORT Convert 
0203 4352                       IMPORT Current 
0204 4352                       IMPORT Draw 
0205 4352                       IMPORT Expand 
0206 4352                       IMPORT Get 
0207 4352                       IMPORT Have 
0208 4352                       IMPORT Make 
0209 4352                       IMPORT Redraw 
0210 4352                       IMPORT Restore 
0211 4352                       IMPORT Save 
0212 4352                       IMPORT Set 
0213 4352                       IMPORT Window 
0214 4352                       IMPORT colorBlack 
0215 4352                       IMPORT infoBarDefProc 
0216 4352                       IMPORT longCall 
0217 4352                       IMPORT pushDpage 
0218 4352                       IMPORT setTheOrigin 
0219 4352                       IMPORT titleBarDefProc 
0220 4352                       IMPORT zeroOrigin 
0221 4352
0222 4352              ;-----------------------------------------------
0223 4352              ;
0224 4352              ;   Forward addresses and entries
0225 4352              ;
0226 4352              ;-----------------------------------------------
0227 4352
0228 4352                       ENTRY pushWindTitle 
0229 4352                       ENTRY unlockTitle 
0230 4352                       ENTRY TaskScroll 
0231 4352                       ENTRY ckZoom 
0232 4352                       ENTRY ck_origin 
0233 4352                       ENTRY cloneRect 
0234 4352                       ENTRY docBehind 
0235 4352                       ENTRY docCallDefProc 
0236 4352                       ENTRY docPosition 
0237 4352                       ENTRY docRecSize 
0238 4352                       ENTRY docDispose 
0239 4352                       ENTRY endFrameDraw 
0240 4352                       ENTRY findCtlHand 
0241 4352                       ENTRY frameRect 
0242 4352                       ENTRY getDeskBounds 
0243 4352                       ENTRY getGlobalRect 
0244 4352                       ENTRY getLineSize 
0245 4352                       ENTRY getLocalRect 
0246 4352                       ENTRY getLong 
0247 4352                       ENTRY getRgnBounds 
0248 4352                       ENTRY hDrawInfo 
0249 4352                       ENTRY hEndInfoDraw 
0250 4352                       ENTRY hGetColorTable 
0251 4352                       ENTRY hGetDataSize 
0252 4352                       ENTRY hGetFrameFlag 
0253 4352                       ENTRY hGetInfoDraw 
0254 4352                       ENTRY hGetInfoRect 
0255 4352                       ENTRY hGetInfoRefCon 
0256 4352                       ENTRY hGetMaxGrow 
0257 4352                       ENTRY hGetOrgMask 
0258 4352                       ENTRY hGetOrigin 
0259 4352                       ENTRY hGetPage 
0260 4352                       ENTRY hGetScroll 
0261 4352                       ENTRY hGetTitle 
0262 4352                       ENTRY hGetZoomRect 
0263 4352                       ENTRY hNewSize 
0264 4352                       ENTRY hSetColorTable 
0265 4352                       ENTRY hSetDataSize 
0266 4352                       ENTRY hSetFrameFlag 
0267 4352                       ENTRY hSetInfoDraw 
0268 4352                       ENTRY hSetInfoRefCon 
0269 4352                       ENTRY hSetMaxGrow 
0270 4352                       ENTRY hSetOrgMask 
0271 4352                       ENTRY hSetOrigin 
0272 4352                       ENTRY hSetPage 
0273 4352                       ENTRY hSetScroll 
0274 4352                       ENTRY hSetTitle 
0275 4352                       ENTRY hSetZoomRect 
0276 4352                       ENTRY hStartDrawing 
0277 4352                       ENTRY hStartInfoDraw 
0278 4352                       ENTRY hStartMove 
0279 4352                       ENTRY hTask 
0280 4352                       ENTRY hZoomWindow 
0281 4352                       ENTRY makeRectLocal 
0282 4352                       ENTRY new_origin 
0283 4352                       ENTRY pushLineSize 
0284 4352                       ENTRY pushParam 
0285 4352                       ENTRY pushPort 
0286 4352                       ENTRY pushWindLong 
0287 4352                       ENTRY pushrect 
0288 4352                       ENTRY pushwrect 
0289 4352                       ENTRY saveWOrigin 
0290 4352                       ENTRY saveWRect 
0291 4352                       ENTRY setDefFull 
0292 4352                       ENTRY setLong 
0293 4352                       ENTRY setTitleWidth 
0294 4352                       ENTRY setWindField 
0295 4352                       ENTRY setcolorptr 
0296 4352                       ENTRY unlockColor 
0297 4352                       ENTRY setoutline 
0298 4352                       ENTRY shutdown 
0299 4352                       ENTRY startFrameDraw 
0300 4352                       ENTRY startup 
0301 4352                       ENTRY swap_origin 
0302 4352                       ENTRY swap_word 
0303 4352                       ENTRY zeroDesRect 
0304 4352
0305 4352
0306 4352
0307 4352              ;
0308 4352              ;
0309 4352              ;====================================================
0310 4352              ;          Standard document window defProc.
0311 4352              ;====================================================
0312 4352              ;
0313 4352              ;   IN:    PUSH:LONG - space for result.
0314 4352              ;          PUSH:LONG - pointer to Window Manager globals.
0315 4352              ;          PUSH:WORD - operation to perform.
0316 4352              ;          PUSH:LONG - pointer to window's port.
0317 4352              ;          PUSH:LONG - addtional parameter defined by operation.
0318 4352              ;          JSL to defProc.
0319 4352              ;
0320 4352              ;  OUT:    result = result from operation.
0321 4352              ;          Carry clear if no error.
0322 4352              ;          Carry set if error, Y = error code.
0323 4352              ;
0324 4352                       EXPORT docDefProc 
0325 4352              docDefProc PROC 
0326 4352              ;
0327 4352              ;
0328 4352              ; --- Set up for defProc call --------------------------------
0329 4352              ;
0330 4352 20 D2 54              jsr   startup
0331 4355              ;
0332 4355              ;
0333 4355              ; --- Dispatch to operation handler --------------------------
0334 4355              ;
0335 4355 A5 48                 lda   <operation
0336 4357 C9 0B 00              cmp   #11                      Operation out of range?
0337 435A B0 0E                 bcs   skip1
0338 435C              ;
0339 435C 0A                    asl   a
0340 435D AA                    tax   
0341 435E FC 6D 43              jsr   (taskTable,x)
0342 4361 85 4E                 sta   <result                  x/a = result.
0343 4363 86 50                 stx   <result+2                y = error code if carry set.
0344 4365 B0 03                 bcs   skip1
0345 4367 A0 00 00              ldy   #0                       No error code.
0346 436A              ;
0347 436A              ;
0348 436A              ; --- Return to caller ---------------------------------------
0349 436A              ;
0350 436A 82 70 11     skip1    brl   shutdown
0351 436D              ;
0352 436D              ;
0353 436D 83 43        taskTable DC W:docDraw                  0  Draw window frame.
0354 436F E9 43                 DC W:docHit                    1  Hit test window.
0355 4371 A9 44                 DC W:docRgns                   2  Compute struc and content regions.
0356 4373 64 44                 DC W:docInit                   3  Additional initailization.
0357 4375 B9 47                 DC W:docDispose                4  Additional diaposal.
0358 4377 E0 47                 DC W:docDrag                   5  Return address of draw frame routine.
0359 4379 E6 47                 DC W:docGrow                   6  Draw grow window outline.
0360 437B EC 47                 DC W:docRecSize                7  Return window record size.
0361 437D 2A 48                 DC W:docPosition               8  Return position and size of window.
0362 437F 37 48                 DC W:docBehind                 9  Return where window goes in list.
0363 4381 70 48                 DC W:docCallDefProc            10 Generic call to defProc.
0364 4383              ;
0365 4383              ;
0366 4383              ; = = = = = = = = = = = = = = = = = = = = = = = =
0367 4383              ; 0        Draw document window's frame.
0368 4383              ;100= = = = = = = = = = = = = = = = = = = = = = =
0369 4383              ;
0370 4383              ;   IN:    <w_wind = window to draw.
0371 4383              ;          <w_param = part to draw, 0=entire, 1=close, 2=zoom, 3=info.
0372 4383              ;          <w_param+2 = bit 15 = 1 to hilite.
0373 4383              ;
0374 4383              ;  OUT:    x/a = result.
0375 4383              ;
0376 4383 A5 40        docDraw  lda   <w_param                 Dispatch to part to draw.
0377 4385 0A                    asl   a
0378 4386 AA                    tax   
0379 4387 7C 8A 43              jmp   (drawParts,x)
0380 438A              ;
0381 438A 92 43 C1 43  drawParts DC W:drawWhole,drawClose,drawZoom,drawInfo
0382 4392              ;
0383 4392              ;
0384 4392              ;--------------------------------------------
0385 4392              ;          Draw entire window frame.
0386 4392              ;110-----------------------------------------
0387 4392              ;
0388 4392 20 CE 53     drawWhole jsr   setcolorptr             Set window's color table pointer.
0389 4395              ;
0390 4395 A0 00 00              ldy   #FRAME_CLR
0391 4398 20 3D 54              jsr   setoutline               Set pen color and pattern.
0392 439B              ;
0393 439B 20 7F 54              jsr   getLocalRect             <w_wrect = frame RECT in local.
0394 439E              ;                                       <w_rect = frame RECT in local.
0395 439E              ;
0396 439E 20 6E 54              jsr   pushLineSize
0397 43A1 A2 04 2C 22           _SetPenSize 
0398 43A8              ;
0399 43A8 20 53 54              jsr   frameRect                Draw outline around frame.
0400 43AB              ;
0401 43AB A0 CF 00              ldy   #wFrameCtls+1            Does the window have any frame controls?
0402 43AE B7 44                 lda   [<w_wind],y
0403 43B0 F0 0A                 beq   exit110
0404 43B2              ;
0405 43B2 20 5E 54              jsr   pushPort                 Pass port that has frame controls.
0406 43B5 A2 10 10 22           _DrawControls 
0407 43BC              ;
0408 43BC 20 07 54     exit110  jsr   unlockColor              Leave color table unlocked.
0409 43BF 18                    clc                            No error flag.
0410 43C0 60                    rts   
0411 43C1              ;
0412 43C1              ;
0413 43C1              ;--------------------------------------------
0414 43C1              ;          Draw close box.
0415 43C1              ;120-----------------------------------------
0416 43C1              ;
0417 43C1              ;   IN:    <w_param+2 = negative to hilite.
0418 43C1              ;
0419 43C1 A9 11 00     drawClose lda   #closePart              Hilite close box, just in case.
0420 43C4              ;
0421 43C4 A6 42        enter120 ldx   <w_param+2               Hilite?
0422 43C6 30 03                 bmi   store120
0423 43C8 A9 00 00              lda   #0                       Unhilite.
0424 43CB 85 42        store120 sta   <w_param+2               Part to hilite.
0425 43CD              ;
0426 43CD A9 00 00              lda   #titleBarID              Find title bar control.
0427 43D0 20 6A 49              jsr   findCtlHand
0428 43D3 B0 0B                 bcs   exit120
0429 43D5              ;
0430 43D5 D4 42                 pei   <w_param+2               Pass part to hilite or unhilite.
0431 43D7 DA                    phx                            Pass handle of control.
0432 43D8 48                    pha   
0433 43D9 A2 10 11 22           _HiliteControl                 Draw the part.
0434 43E0              ;
0435 43E0 18           exit120  clc   
0436 43E1 60                    rts   
0437 43E2              ;
0438 43E2              ;
0439 43E2              ;--------------------------------------------
0440 43E2              ;          Draw zoom box.
0441 43E2              ;130-----------------------------------------
0442 43E2              ;
0443 43E2              ;   IN:    <w_param+2 = negative to hilite.
0444 43E2              ;
0445 43E2 A9 12 00     drawZoom lda   #zoomPart                Hilite zoom box.
0446 43E5 80 DD                 bra   enter120
0447 43E7              ;
0448 43E7              ;
0449 43E7              ;--------------------------------------------
0450 43E7              ;          Draw info bar.
0451 43E7              ;140-----------------------------------------
0452 43E7              ;
0453 43E7              drawInfo                                ; 
0454 43E7 18                    clc   
0455 43E8 60                    rts   
0456 43E9              ;
0457 43E9              ;
0458 43E9              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0459 43E9              ; 1        Test hit on a standard documnet window.
0460 43E9              ;200= = = = = = = = = = = = = = = = = = = = = = = = = = = =
0461 43E9              ;
0462 43E9              ;   IN:    w_param = y point to check, local to window frame.
0463 43E9              ;          w_param+2 = x point to check, local to window frame.
0464 43E9              ;          yrat = y global point to check.
0465 43E9              ;          xrat = x global point to check.
0466 43E9              ;          w_param = y local point to check.
0467 43E9              ;          w_param+2 = x local point to check.
0468 43E9              ;
0469 43E9              ;  OUT:    a = part point is zero if no point found,
0470 43E9              ;              else a = wInContent
0471 43E9              ;                       wInDrag
0472 43E9              ;                       wInGrow
0473 43E9              ;                       wInGoAway
0474 43E9              ;                       wInZoom
0475 43E9              ;                       wInInfo
0476 43E9              ;                       wInFrame
0477 43E9              ;
0478 43E9              docHit                                  ; 
0479 43E9              ;
0480 43E9              foundCtl equ   w_work
0481 43E9              ;
0482 43E9 A9 1B 00              lda   #wInFrame                If no controls, on frame, just in case.
0483 43EC A0 CF 00              ldy   #wFrameCtls+1            Does the window have any frame controls?
0484 43EF B7 44                 lda   [<w_wind],y
0485 43F1 F0 65                 beq   exit
0486 43F3              ;
0487 43F3 20 AC 53              jsr   pushParam                Pass pointer to point to check.
0488 43F6 A2 04 84 22           _LocalToGlobal                 Convert point to check to global.
0489 43FD              ;
0490 43FD 48                    pha                            Space for result.
0491 43FE A9 15 00              lda   #foundCtl                Pass place to store handle of control.
0492 4401 20 64 8F              jsr   pushDpage
0493 4404 D4 42                 pei   <w_param+2               Pass x point to check (global).
0494 4406 D4 40                 pei   <w_param                 Pass y point to check (global).
0495 4408 48                    pha                            Pass pointer to window.
0496 4409 48                    pha   
0497 440A A2 04 1C 22           _GetPort                       Current port is port to check.
0498 4411 A2 10 13 22           _FindControl 
0499 4418 A9 1B 00              lda   #wInFrame                Not on control, just in case.
0500 441B FA                    plx                            Control found?
0501 441C F0 3A                 beq   exit
0502 441E              ;
0503 441E A9 16 00              lda   #wInGoAway
0504 4421 E0 11 00              cpx   #closePart               In close box part?
0505 4424 F0 32                 beq   exit
0506 4426              ;
0507 4426 A9 17 00              lda   #wInZoom
0508 4429 E0 12 00              cpx   #zoomPart                In zoom box part?
0509 442C F0 2A                 beq   exit
0510 442E              ;
0511 442E 48                    pha                            Space for result.
0512 442F 48                    pha   
0513 4430 D4 17                 pei   <foundCtl+2              Pass handle of found control.
0514 4432 D4 15                 pei   <foundCtl
0515 4434 A2 10 23 22           _GetCtlRefCon 
0516 443B 68                    pla   
0517 443C FA                    plx                            Get control's ID.
0518 443D BF 5A 44 FD           lda   >hitCodes,x              Fetch code to return.
0519 4441 C9 14 00              cmp   #wInDrag                 Special case wInDrag.
0520 4444 D0 12                 bne   exit
0521 4446              ;
0522 4446 A0 D2 00              ldy   #wFrame                  Is window moveable?
0523 4449 B7 44                 lda   [<w_wind],y
0524 444B 29 80 00              and   #F_MOVE
0525 444E D0 05                 bne   okMove
0526 4450 A9 1B 00              lda   #wInFrame                Window is not moveable.
0527 4453 80 03                 bra   exit
0528 4455              ;
0529 4455 A9 14 00     okMove   lda   #wInDrag                 Window is moveable.
0530 4458              ;
0531 4458 18           exit     clc                            No error.
0532 4459 60                    rts   
0533 445A              ;
0534 445A 14 00 18 00  hitCodes DC W:wInDrag,wInInfo,wInFrame,wInFrame,wInGrow
0535 4464              ;
0536 4464              ;
0537 4464              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
0538 4464              ; 3        Perform additional initialization.
0539 4464              ;400= = = = = = = = = = = = = = = = = = = = = = = = = =
0540 4464              ;
0541 4464              ;   IN:    w_wrect = content area in global coordinates.
0542 4464              ;          w_param = pointer to NewWindow parameter list:
0543 4464              ;                      WORD - window frame type:
0544 4464              ;                                     $8000 - title bar.
0545 4464              ;                                     $4000 - close box.
0546 4464              ;                                     $1000 - right scroll bar.
0547 4464              ;                                     $0800 - bottom scroll bar.
0548 4464              ;                                     $0400 - sizer box.
0549 4464              ;                                     $0100 - full box.
0550 4464              ;                                     $0080 - allow move on title bar.
0551 4464              ;                                     $0020 - visible.
0552 4464              ;                      LONG - pointer to window's title (first byte = length).
0553 4464              ;                      LONG - reference value, application reserved.
0554 4464              ;                      RECT - full rect for content, zero for default.
0555 4464              ;                      LONG - pointer to color window's table.
0556 4464              ;                      WORD - vertical offset of content region.
0557 4464              ;                      WORD - horizontal offset of content region.
0558 4464              ;                      WORD - height of total data area.
0559 4464              ;                      WORD - width of total data area.
0560 4464              ;                      WORD - maximum height of content allowed in grow window.
0561 4464              ;                      WORD - maximum width of content allowed in grow window.
0562 4464              ;                      WORD - pixels to scroll vertically for arrows.
0563 4464              ;                      WORD - pixels to scroll horizontally for arrows.
0564 4464              ;                      WORD - pixels to scroll vertically for page region.
0565 4464              ;                      WORD - pixels to scroll horizontally for page region.
0566 4464              ;                      LONG - value passed to draw Information bar routine.
0567 4464              ;                      WORD - height of information bar.
0568 4464              ;                      LONG - address of window's definition procedure.
0569 4464              ;                      LONG - address of routine that will draw on Info. Bar.
0570 4464              ;                      LONG - address of routine that will draw content region.
0571 4464              ;                      RECT - the position and size of content area.
0572 4464              ;                      LONG - poistion window goes in window list.
0573 4464              ;                      LONG - address of window record, zero to allocate.
0574 4464              ;
0575 4464              ;  OUT:    Carry clear if window created if no error.
0576 4464              ;          Carry set if error, y = error code.
0577 4464              ;
0578 4464              docInit                                 ; 
0579 4464              ;
0580 4464              ;
0581 4464              ; --- Transferr data from parameter list to window record ----
0582 4464              ;
0583 4464              ; wFrame, wTitle, wRefCon, wZoom, wColor, wYOrigin, wXorigin, wDataH, wDataW,
0584 4464              ; wMaxH, wMaxW, wScrollVer, wScrollHor, wPageVer, wPageHor, wInfoRefCon,
0585 4464              ; wInfoHeight, wFrameDefProc, wInfoDefProc.
0586 4464              ;
0587 4464 A0 D2 00              ldy   #wframe                  Place in record to put parameter list.
0588 4467 A2 02 00              ldx   #p_wframe
0589 446A 5A           lop2     phy   
0590 446B 9B                    txy   
0591 446C B7 40                 lda   [<w_param],y
0592 446E 7A                    ply   
0593 446F 17 44                 ora   [<w_wind],y              OR to not disturb wFrame bits already set.
0594 4471 97 44                 sta   [<w_wind],y
0595 4473 C8                    iny   
0596 4474 C8                    iny   
0597 4475 E8                    inx   
0598 4476 E8                    inx   
0599 4477 E0 3A 00              cpx   #p_updateDraw
0600 447A D0 EE                 bne   lop2
0601 447C              ;
0602 447C              ;
0603 447C A0 DA 00              ldy   #wOrgn_mask              Set the wOrgn_mask field.
0604 447F A9 FF FF              lda   #$FFFF                   Set horizontal origin mask to single
0605 4482 97 44                 sta   [<w_wind],y              pixel resolution.
0606 4484              ;
0607 4484 A0 08 00              ldy   #p_wRefCon               Set the wRefCon field.
0608 4487 A2 B4 00              ldx   #wRefCon+2
0609 448A 20 95 47              jsr   setWindField
0610 448D              ;
0611 448D A0 3A 00              ldy   #p_updateDraw            Set the wContDraw field.
0612 4490 A2 B8 00              ldx   #wContDraw+2
0613 4493 20 95 47              jsr   setWindField
0614 4496              ;
0615 4496              ;
0616 4496              ; --- Make sure that the data sizes are in range -------------
0617 4496              ;
0618 4496 A0 EC 00              ldy   #data_h                  Force data size to be in bounds.
0619 4499 B7 44                 lda   [<w_wind],y
0620 449B 29 FF 3F              and   #$3FFF
0621 449E 97 44                 sta   [<w_wind],y
0622 44A0 C8                    iny   
0623 44A1 C8                    iny   
0624 44A2 B7 44                 lda   [<w_wind],y
0625 44A4 29 FF 3F              and   #$3FFF
0626 44A7 97 44                 sta   [<w_wind],y
0627 44A9              ;
0628 44A9              ;
0629 44A9              ;
0630 44A9              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0631 44A9              ; 2        Initialize window's StructRgn and ContentRgn.
0632 44A9              ;400= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
0633 44A9              ;
0634 44A9              ;   IN:    w_wind = window pointer.
0635 44A9              ;
0636 44A9              ;  OUT:    w_rect = trashed.
0637 44A9              ;          w_wrect = trashed.
0638 44A9              ;
0639 44A9              growHeight equ   w_work                 Local direct page use.
0640 44A9              growWidth equ   growHeight+2
0641 44A9              frame    equ   growWidth+2
0642 44A9              portPtr  equ   frame+2
0643 44A9              temp     equ   portPtr+4
0644 44A9              contentH equ   temp+4
0645 44A9              contentW equ   contentH+2
0646 44A9              ;
0647 44A9              ;
0648 44A9 20 9D 54     docRgns  jsr   getGlobalRect            w_wrect = port bounds.
0649 44AC 20 C2 53              jsr   cloneRect                Clone 'w_wrect' into 'w_rect'.
0650 44AF              ;
0651 44AF              ;
0652 44AF              ;----------------------------------------------
0653 44AF              ;          Set size of content region.
0654 44AF              ;----------------------------------------------
0655 44AF              ;
0656 44AF A5 11                 lda   <w_rect+y2               Compute and save content height.
0657 44B1 38                    sec   
0658 44B2 E5 0D                 sbc   <w_rect+y1
0659 44B4 85 23                 sta   <contentH
0660 44B6              ;
0661 44B6 A5 13                 lda   <w_rect+x2               Compute and save content width.
0662 44B8 38                    sec   
0663 44B9 E5 0F                 sbc   <w_rect+x1
0664 44BB 85 25                 sta   <contentW
0665 44BD              ;
0666 44BD A0 C4 00              ldy   #wcontRgn+2              Pass handle of content region.
0667 44C0 20 B7 53              jsr   pushWindLong
0668 44C3 20 B1 53              jsr   pushrect
0669 44C6 A2 04 6C 22           _RectRgn 
0670 44CD              ;
0671 44CD              ;
0672 44CD              ;----------------------------------------------------------------------
0673 44CD              ;          Compute size of frame by expanding the content area.
0674 44CD              ;----------------------------------------------------------------------
0675 44CD              ;
0676 44CD              ;
0677 44CD              ; ------ Get size of grow box --------------------------------
0678 44CD              ;
0679 44CD A0 D2 00              ldy   #wframe
0680 44D0 B7 44                 lda   [<w_wind],y
0681 44D2 85 19                 sta   <frame                   Save wFrame.
0682 44D4 29 00 1C              and   #F_RSCRL+F_BSCRL+F_GROW Any controls that need grow?
0683 44D7 F0 0F                 beq   skip404                  Don't call GrowSize if none.
0684 44D9              ;
0685 44D9 48                    pha                            Space for result
0686 44DA 48                    pha   
0687 44DB A2 10 1E 22           _GrowSize                      Get the size of the grow box.
0688 44E2 68                    pla   
0689 44E3 85 15                 sta   <growHeight
0690 44E5 68                    pla   
0691 44E6 85 17                 sta   <growWidth
0692 44E8              ;
0693 44E8              ;
0694 44E8              ; ------ Expand width of frame outline -----------------------
0695 44E8              ;
0696 44E8 20 B1 53     skip404  jsr   pushrect                 Pass RECT of entire window.
0697 44EB A0 00 00              ldy   #lineW                   Pass width of vertical line negated.
0698 44EE B7 4A                 lda   [<globals],y
0699 44F0 49 FF FF              eor   #$FFFF
0700 44F3 1A                    inc   a
0701 44F4 48                    pha   
0702 44F5 F4 FF FF              pea   $FFFF                    Pass height of horizontal line negated.
0703 44F8 A2 04 4C 22           _InsetRect                     Expand window RECT by width of frame.
0704 44FF              ;
0705 44FF              ;
0706 44FF              ; ------ Add title bar ---------------------------------------
0707 44FF              ;
0708 44FF A5 19                 lda   <frame                   Save wFrame.
0709 4501 10 0B                 bpl   skip400                  Title bar?
0710 4503              ;
0711 4503 A0 02 00              ldy   #titleHeight
0712 4506 A5 0D                 lda   <w_rect+y1
0713 4508 38                    sec   
0714 4509 F7 4A                 sbc   [<globals],y
0715 450B 1A                    inc   a                        Share top line.
0716 450C 85 0D                 sta   <w_rect+y1
0717 450E              ;
0718 450E              ;
0719 450E              ; ------ Add info bar ----------------------------------------
0720 450E              ;
0721 450E A5 19        skip400  lda   <frame
0722 4510 29 10 00              and   #F_INFO                  Information bar?
0723 4513 F0 0B                 beq   skip401
0724 4515              ;
0725 4515 A5 0D                 lda   <w_rect+y1
0726 4517 A0 00 01              ldy   #wInfoHeight
0727 451A 38                    sec   
0728 451B F7 44                 sbc   [<w_wind],y              Raise top side for information bar.
0729 451D 1A                    inc   a                        Share top line.
0730 451E 85 0D                 sta   <w_rect+y1
0731 4520              ;
0732 4520              ;
0733 4520              ; ------ Add vertical scroll bar -----------------------------
0734 4520              ;
0735 4520 A5 19        skip401  lda   <frame
0736 4522 29 00 10              and   #F_RSCRL                 Right scroll bar?
0737 4525 F0 0D                 beq   skip402
0738 4527              ;
0739 4527 A5 13                 lda   <w_rect+x2
0740 4529 18                    clc   
0741 452A 65 17                 adc   <growWidth               Expand right side for vertical scroll.
0742 452C              ;
0743 452C A0 00 00              ldy   #lineW
0744 452F 38                    sec   
0745 4530 F7 4A                 sbc   [<globals],y
0746 4532 85 13                 sta   <w_rect+x2
0747 4534              ;
0748 4534              ;
0749 4534              ; ------ Add horizontal scroll bar ---------------------------
0750 4534              ;
0751 4534 A5 19        skip402  lda   <frame
0752 4536 29 00 08              and   #F_BSCRL                 Bottom scroll bar?
0753 4539 F0 08                 beq   skip403
0754 453B              ;
0755 453B A5 11                 lda   <w_rect+y2
0756 453D 18                    clc   
0757 453E 65 15                 adc   <growHeight              Expand bottom side for bottom scroll.
0758 4540 3A                    dec   a
0759 4541 85 11                 sta   <w_rect+y2
0760 4543              ;
0761 4543              ;
0762 4543              ; --- Set size of window's strucRgn --------------------------
0763 4543              ;
0764 4543 A0 C0 00     skip403  ldy   #wstrucRgn+2             Pass handle of StructRgn.
0765 4546 20 B7 53              jsr   pushWindLong
0766 4549 20 B1 53              jsr   pushrect                 Set to global RECT in 'w_rect'.
0767 454C A2 04 6C 22           _RectRgn 
0768 4553              ;
0769 4553              ;
0770 4553              ;------------------------------------------------------
0771 4553              ;          Create any needed frame controls.
0772 4553              ;------------------------------------------------------
0773 4553              ;
0774 4553              ;   <w_rect = frame's rect, in global.
0775 4553              ;   <w_wrect = content rect, in global.
0776 4553              ;
0777 4553 48                    pha                            Space for result.
0778 4554 48                    pha   
0779 4555 A2 04 1C 22           _GetPort 
0780 455C 68                    pla   
0781 455D 85 1B                 sta   <portPtr                 Save pointer to current port.
0782 455F 68                    pla   
0783 4560 85 1D                 sta   <portPtr+2
0784 4562              ;
0785 4562 A5 19                 lda   <frame
0786 4564 29 10 9C              and   #F_RSCRL+F_BSCRL+F_GROW+F_TITLE+F_INFO
0787 4567 D0 03                 bne   ok403
0788 4569 82 8E 01              brl   setDefFull               If no controls, skip kill and create.
0789 456C              ;
0790 456C D4 1D        ok403    pei   <portPtr+2               Pass port to kill controls in.
0791 456E D4 1B                 pei   <portPtr
0792 4570 A2 10 0B 22           _KillControls 
0793 4577              ;
0794 4577              ;
0795 4577              ;-------------------------------------------
0796 4577              ;          Create frame controls.
0797 4577              ;-------------------------------------------
0798 4577              ;
0799 4577              ; --- Convert bounds to local --------------------------------
0800 4577              ;
0801 4577 20 88 54              jsr   makeRectLocal            <w_wrect = local, <w_rect = <w_wrect clone.
0802 457A              ;
0803 457A              ;          <w_wrect = bounds of window structure in local.
0804 457A              ;          <w_rect = bounds of window structure in local.
0805 457A              ;
0806 457A              ; --- Create title bar control -------------------------------
0807 457A              ;
0808 457A A5 19                 lda   <frame                   Is there a title bar?
0809 457C 29 00 80              and   #F_TITLE
0810 457F D0 04                 bne   ok404
0811 4581              ;
0812 4581 E6 0D                 inc   <w_rect+y1               Special case no title bar so info bar
0813 4583 80 3E                 bra   makeInfo                 and vertical scroll bar can share lines.
0814 4585              ;
0815 4585 A0 02 00     ok404    ldy   #titleHeight             Compute bounds of title bar.
0816 4588 B7 4A                 lda   [<globals],y
0817 458A 85 11                 sta   <w_rect+y2
0818 458C              ;
0819 458C 20 A5 47              jsr   setTitleWidth            Set the width of the new title.
0820 458F              ;
0821 458F 48                    pha                            Space for result.
0822 4590 48                    pha   
0823 4591 D4 1D                 pei   <portPtr+2               Pass window owner.
0824 4593 D4 1B                 pei   <portPtr
0825 4595 20 B1 53              jsr   pushRect                 Pass address of bounds RECT.
0826 4598 D4 46                 pei   <w_wind+2                Pass ctlData.
0827 459A D4 44                 pei   <w_wind
0828 459C A5 19                 lda   <frame                   Pass flags.
0829 459E 29 00 41              and   #F_CLOSE+F_ZOOM
0830 45A1 EB                    xba   
0831 45A2 48                    pha   
0832 45A3 48                    pha                            Pass value (not used, set by control).
0833 45A4 48                    pha                            Pass param1 (not used).
0834 45A5 48                    pha                            Pass param2 (not used).
0835 45A6 F4 FD 00              pea   titleBarDefProc>>16      Pass address of control defProc.
0836 45A9 F4 DC 3A              pea   titleBarDefProc
0837 45AC F4 00 00              pea   titleBarID               Pass refCon.
0838 45AF 48                    pha                            Low word not used.
0839 45B0 48                    pha                            Pass color table (not used).
0840 45B1 48                    pha   
0841 45B2 A2 10 09 22           _NewControl 
0842 45B9 68                    pla                            Don't need returned handle.
0843 45BA 68                    pla   
0844 45BB              ;
0845 45BB A5 11                 lda   <w_rect+y2               Subtract title bar from frame RECT.
0846 45BD 85 0D                 sta   <w_rect+y1
0847 45BF A5 09                 lda   <w_wrect+y2
0848 45C1 85 11                 sta   <w_rect+y2
0849 45C3              ;
0850 45C3              ;
0851 45C3              ; --- Create info bar control --------------------------------
0852 45C3              ;
0853 45C3 A5 19        makeInfo lda   <frame                   Is there a info bar?
0854 45C5 29 10 00              and   #F_INFO
0855 45C8 F0 3D                 beq   makeVScroll
0856 45CA              ;
0857 45CA C6 0D                 dec   <w_rect+y1               Share top line with bottom of title.
0858 45CC              ;
0859 45CC A0 00 01              ldy   #wInfoHeight             Compute bounds of info bar.
0860 45CF B7 44                 lda   [<w_wind],y
0861 45D1 18                    clc   
0862 45D2 65 0D                 adc   <w_rect+y1
0863 45D4 85 11                 sta   <w_rect+y2
0864 45D6              ;
0865 45D6 48                    pha                            Space for result.
0866 45D7 48                    pha   
0867 45D8 D4 1D                 pei   <portPtr+2               Pass window owner.
0868 45DA D4 1B                 pei   <portPtr
0869 45DC 20 B1 53              jsr   pushRect                 Pass address of bounds RECT.
0870 45DF D4 46                 pei   <w_wind+2                Pass ctlData.
0871 45E1 D4 44                 pei   <w_wind
0872 45E3 A9 00 00              lda   #0                       Common need.
0873 45E6 48                    pha                            Pass flags.
0874 45E7 48                    pha                            Pass value.
0875 45E8 48                    pha                            Pass param1 (not used).
0876 45E9 48                    pha                            Pass param2 (not used).
0877 45EA F4 FD 00              pea   infoBarDefProc>>16       Pass address of control defProc.
0878 45ED F4 00 3E              pea   infoBarDefProc
0879 45F0 F4 02 00              pea   infoBarID                Pass refCon.
0880 45F3 48                    pha                            Low word not used.
0881 45F4 48                    pha                            Pass color table (not used).
0882 45F5 48                    pha   
0883 45F6 A2 10 09 22           _NewControl 
0884 45FD 68                    pla                            Don't need returned handle.
0885 45FE 68                    pla   
0886 45FF              ;
0887 45FF A5 11                 lda   <w_rect+y2               Subtract info bar from frame RECT.
0888 4601 85 0D                 sta   <w_rect+y1
0889 4603 A5 09                 lda   <w_wrect+y2
0890 4605 85 11                 sta   <w_rect+y2
0891 4607              ;
0892 4607              ;
0893 4607              ; --- Create vertical scroll bar -----------------------------
0894 4607              ;
0895 4607 A5 19        makeVScroll lda   <frame                Is there a vertical scroll bar?
0896 4609 29 00 10              and   #F_RSCRL
0897 460C F0 4D                 beq   makeGrow
0898 460E              ;
0899 460E C6 0D                 dec   <w_rect+y1               Share top side.
0900 4610 A5 13                 lda   <w_rect+x2               Compute bounds of info bar.
0901 4612 38                    sec   
0902 4613 E5 17                 sbc   <growWidth
0903 4615 85 0F                 sta   <w_rect+x1
0904 4617              ;
0905 4617 A5 19                 lda   <frame                   If no grow box or horizontal scroll
0906 4619 29 00 0C              and   #F_BSCRL+F_GROW          bar than go to bottom of window.
0907 461C F0 08                 beq   ok401
0908 461E              ;
0909 461E A5 11                 lda   <w_rect+y2               Pull bottom of vertical scroll bar up
0910 4620 38                    sec                            to make room for grow box and/or
0911 4621 E5 15                 sbc   <growHeight              horizontal scroll bar.
0912 4623 1A                    inc   a
0913 4624 85 11                 sta   <w_rect+y2
0914 4626              ;
0915 4626 48           ok401    pha                            Space for result.
0916 4627 48                    pha   
0917 4628 D4 1D                 pei   <portPtr+2               Pass window owner.
0918 462A D4 1B                 pei   <portPtr
0919 462C 20 B1 53              jsr   pushRect                 Pass address of bounds RECT.
0920 462F 48                    pha                            Pass title (not used).
0921 4630 48                    pha   
0922 4631 F4 03 00              pea   $0003                    Pass flags.
0923 4634 A0 E8 00              ldy   #y_origin                Pass value.
0924 4637 B7 44                 lda   [<w_wind],y
0925 4639 48                    pha   
0926 463A D4 23                 pei   <contentH                Pass view height in param1.
0927 463C A0 EC 00              ldy   #data_h                  Pass data height in param2.
0928 463F B7 44                 lda   [<w_wind],y
0929 4641 48                    pha   
0930 4642 A9 00 00              lda   #0                       Common need.
0931 4645 F4 00 06              pea   $0600                    Pass defProc for scroll bar.
0932 4648 48                    pha   
0933 4649 F4 04 00              pea   VScrollID                Pass refCon (ID for vertical bar).
0934 464C 48                    pha   
0935 464D 48                    pha                            Pass default color table.
0936 464E 48                    pha   
0937 464F A2 10 09 22           _NewControl 
0938 4656 68                    pla                            Get handle of scroll bar.
0939 4657 FA                    plx   
0940 4658 20 7A 47              jsr   setBarValue              Move scroll bar value into refCon
0941 465B              ;
0942 465B              ;
0943 465B              ; --- Create grow box control --------------------------------
0944 465B              ;
0945 465B A5 19        makeGrow lda   <frame                   Is there a grow box?
0946 465D 29 00 04              and   #F_GROW
0947 4660 F0 37                 beq   makeHScroll
0948 4662              ;
0949 4662 A5 0B                 lda   <w_wrect+x2              Compute bounds of grow box.
0950 4664 85 13                 sta   <w_rect+x2
0951 4666 38                    sec   
0952 4667 E5 17                 sbc   <growWidth
0953 4669 85 0F                 sta   <w_rect+x1
0954 466B A5 09                 lda   <w_wrect+y2
0955 466D 85 11                 sta   <w_rect+y2
0956 466F 38                    sec   
0957 4670 E5 15                 sbc   <growHeight
0958 4672 85 0D                 sta   <w_rect+y1
0959 4674              ;
0960 4674 48                    pha                            Space for result.
0961 4675 48                    pha   
0962 4676 D4 1D                 pei   <portPtr+2               Pass window owner.
0963 4678 D4 1B                 pei   <portPtr
0964 467A 20 B1 53              jsr   pushRect                 Pass address of bounds RECT.
0965 467D A9 00 00              lda   #0                       Common need.
0966 4680 48                    pha                            Pass title (not used).
0967 4681 48                    pha   
0968 4682 48                    pha                            Pass flags.
0969 4683 48                    pha                            Pass value.
0970 4684 48                    pha                            Pass param1 (not used).
0971 4685 48                    pha                            Pass param2 (not used).
0972 4686 F4 00 08              pea   $0800                    Pass defProc for grow box.
0973 4689 48                    pha   
0974 468A F4 08 00              pea   GrowID                   Pass refCon (ID for grow box).
0975 468D 48                    pha   
0976 468E 48                    pha                            Pass default color table.
0977 468F 48                    pha   
0978 4690 A2 10 09 22           _NewControl 
0979 4697 68                    pla                            Don't need returned handle.
0980 4698 68                    pla   
0981 4699              ;
0982 4699              ;
0983 4699              ; --- Create horizontal scroll bar ---------------------------
0984 4699              ;
0985 4699 A5 19        makeHScroll lda   <frame                Is there a horizontal scroll bar?
0986 469B 29 00 08              and   #F_BSCRL
0987 469E F0 5A                 beq   setDefFull
0988 46A0              ;
0989 46A0 A5 09                 lda   <w_wrect+y2              Compute bounds of horizontal scroll bar.
0990 46A2 85 11                 sta   <w_rect+y2
0991 46A4 38                    sec   
0992 46A5 E5 15                 sbc   <growHeight
0993 46A7 85 0D                 sta   <w_rect+y1
0994 46A9              ;
0995 46A9 A5 07                 lda   <w_wrect+x1
0996 46AB 85 0F                 sta   <w_rect+x1
0997 46AD A5 0B                 lda   <w_wrect+x2
0998 46AF 85 13                 sta   <w_rect+x2
0999 46B1              ;
1000 46B1 A5 19                 lda   <frame                   If no grow box or vertical scroll
1001 46B3 29 00 14              and   #F_RSCRL+F_GROW          bar than go to right side of window.
1002 46B6 F0 0D                 beq   ok402
1003 46B8              ;
1004 46B8 A5 13                 lda   <w_rect+x2               Pull right side of horizontal scroll
1005 46BA 38                    sec                            bar in to make room for grow box and/or
1006 46BB E5 17                 sbc   <growWidth               vertical scroll bar.
1007 46BD A0 00 00              ldy   #lineW
1008 46C0 18                    clc   
1009 46C1 77 4A                 adc   [<globals],y
1010 46C3 85 13                 sta   <w_rect+x2
1011 46C5              ;
1012 46C5 48           ok402    pha                            Space for result.
1013 46C6 48                    pha   
1014 46C7 D4 1D                 pei   <portPtr+2               Pass window owner.
1015 46C9 D4 1B                 pei   <portPtr
1016 46CB 20 B1 53              jsr   pushRect                 Pass address of bounds RECT.
1017 46CE 48                    pha                            Pass title (not used).
1018 46CF 48                    pha   
1019 46D0 F4 1C 00              pea   $001C                    Pass flags.
1020 46D3 A0 EA 00              ldy   #x_origin                Pass value.
1021 46D6 B7 44                 lda   [<w_wind],y
1022 46D8 48                    pha   
1023 46D9 D4 25                 pei   <contentW                Pass view height in param1.
1024 46DB A0 EE 00              ldy   #data_w                  Pass data height in param2.
1025 46DE B7 44                 lda   [<w_wind],y
1026 46E0 48                    pha   
1027 46E1 A9 00 00              lda   #0                       Common need.
1028 46E4 F4 00 06              pea   $0600                    Pass defProc for scroll bar.
1029 46E7 48                    pha   
1030 46E8 F4 06 00              pea   HScrollID                Pass refCon (ID for horizontal bar).
1031 46EB 48                    pha   
1032 46EC 48                    pha                            Pass default color table.
1033 46ED 48                    pha   
1034 46EE A2 10 09 22           _NewControl 
1035 46F5 68                    pla                            Get handle of scroll bar.
1036 46F6 FA                    plx   
1037 46F7 20 7A 47              jsr   setBarValue              Move scroll bar value into refCon
1038 46FA              ;
1039 46FA              ;
1040 46FA              ; = = = = = = = = = = = = = = = = = = = = = = = = =
1041 46FA              ;          Set default maximum grow size
1042 46FA              ;          and full size and position.
1043 46FA              ;410= = = = = = = = = = = = = = = = = = = = = = = =
1044 46FA              ;
1045 46FA              ;   IN:    w_wind = pointer to window.
1046 46FA              ;          w_wind[wmaxheight] = 0 to set default max grow height.
1047 46FA              ;          w_wind[wmaxwidth]  = 0 to set default max grow width.
1048 46FA              ;          w_wind[wfull+y2]   = 0 to set default full size and position.
1049 46FA              ;
1050 46FA              ;  OUT:    Values set if zero flags passed in record.
1051 46FA              ;          w_rect = trash.
1052 46FA              ;          w_wrect = trash.
1053 46FA              ;
1054 46FA                       ENTRY setDefFull 
1055 46FA              setDefFull                              ;       
1056 46FA              ;
1057 46FA A0 BE 00              ldy   #wstrucRgn               Get global coordinates of content.
1058 46FD 20 60 53              jsr   getRgnBounds             <w_wrect = wwStructRgn bounds.
1059 4700 20 C2 53              jsr   cloneRect                <w_rect = <w_wrect.
1060 4703              ;
1061 4703 A0 C2 00              ldy   #wcontRgn                Get global coordinates of content.
1062 4706 20 60 53              jsr   getRgnBounds             <w_wrect = content bounds.
1063 4709              ;
1064 4709 A2 02 00              ldx   #2
1065 470C B5 09        lop410   lda   <w_wrect+y2,x            Get width/height of wcontRgn.
1066 470E 38                    sec   
1067 470F F5 05                 sbc   <w_wrect+y1,x
1068 4711 95 09                 sta   <w_wrect+y2,x            Store width/height in x2/y2.
1069 4713              ;
1070 4713 B5 11                 lda   <w_rect+y2,x             Get width/height of wstrucRgn,
1071 4715 38                    sec   
1072 4716 F5 0D                 sbc   <w_rect+y1,x
1073 4718 F5 09                 sbc   <w_wrect+y2,x            less width/height of wcontRgn,
1074 471A 95 11                 sta   <w_rect+y2,x             equals window border width/height.
1075 471C              ;
1076 471C B5 05                 lda   <w_wrect+y1,x            Get left/top window border,
1077 471E 38                    sec   
1078 471F F5 0D                 sbc   <w_rect+y1,x
1079 4721 95 0D                 sta   <w_rect+y1,x             and store in w_rect+x1/w_rect+y1.
1080 4723              ;
1081 4723 CA                    dex   
1082 4724 CA                    dex   
1083 4725 10 E5                 bpl   lop410
1084 4727              ;
1085 4727 20 69 53              jsr   getDeskBounds            <w_wrect = bounds of desktop.
1086 472A              ;
1087 472A A2 02 00              ldx   #2
1088 472D B5 09        lop411   lda   <w_wrect+y2,x
1089 472F 38                    sec   
1090 4730 F5 05                 sbc   <w_wrect+y1,x            Width/height of desktop,
1091 4732 F5 11                 sbc   <w_rect+y2,x             less width/height of window border,
1092 4734 95 11                 sta   <w_rect+y2,x             equals max content width/height.
1093 4736 CA                    dex   
1094 4737 CA                    dex   
1095 4738 10 F3                 bpl   lop411
1096 473A              ;
1097 473A              ;
1098 473A A0 F0 00              ldy   #wmaxheight              Does maximum grow height need setting?
1099 473D B7 44                 lda   [<w_wind],y
1100 473F D0 04                 bne   ok410
1101 4741              ;
1102 4741 A5 11                 lda   <w_rect+y2               Set default max grow height.
1103 4743 97 44                 sta   [<w_wind],y
1104 4745              ;
1105 4745 C8           ok410    iny   
1106 4746 C8                    iny   
1107 4747 B7 44                 lda   [<w_wind],y              Does maximum grow width need setting?
1108 4749 D0 04                 bne   ok411
1109 474B              ;
1110 474B A5 13                 lda   <w_rect+x2               Set default max grow width.
1111 474D 97 44                 sta   [<w_wind],y
1112 474F              ;
1113 474F              ;
1114 474F              ; --- Set default full RECT ------------------------------------------
1115 474F              ;
1116 474F A0 E0 00     ok411    ldy   #wfull+y2
1117 4752 B7 44                 lda   [<w_wind],y              Does full RECT need setting?
1118 4754 D0 22                 bne   exit410
1119 4756              ;
1120 4756 A5 05                 lda   <w_wrect+y1              Get desktop's top side,
1121 4758 18                    clc   
1122 4759 65 0D                 adc   <w_rect+y1               plus window's top border,
1123 475B A0 DC 00              ldy   #wfull+y1
1124 475E 97 44                 sta   [<w_wind],y              equals full top side,
1125 4760 65 11                 adc   <w_rect+y2               plus max height,
1126 4762 A0 E0 00              ldy   #wfull+y2
1127 4765 97 44                 sta   [<w_wind],y              equals full bottom side.
1128 4767              ;
1129 4767 A5 07                 lda   <w_wrect+x1              Get desktop's left side,
1130 4769 18                    clc   
1131 476A 65 0F                 adc   <w_rect+x1               plus window's left border,
1132 476C A0 DE 00              ldy   #wfull+x1
1133 476F 97 44                 sta   [<w_wind],y              equals full left side,
1134 4771 65 13                 adc   <w_rect+x2               plus max width,
1135 4773 A0 E2 00              ldy   #wfull+x2
1136 4776 97 44                 sta   [<w_wind],y              equals full right side.
1137 4778              ;
1138 4778 18           exit410  clc                            No error flag.
1139 4779 60                    rts   
1140 477A              ;
1141 477A              ;
1142 477A              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
1143 477A              ;          Move scroll bar value into refCon.
1144 477A              ;420= = = = = = = = = = = = = = = = = = = = = = = = = =
1145 477A              ;
1146 477A              ;   In:    x/a = handle of control.
1147 477A              ;
1148 477A              ;  OUT:    CtlRefCon field = CtlValue field.
1149 477A              ;          <temp = trash.
1150 477A              ;
1151 477A 85 1F        setBarValue sta   <temp
1152 477C 86 21                 stx   <temp+2
1153 477E              ;
1154 477E A0 02 00              ldy   #2                       Deference handle.
1155 4781 B7 1F                 lda   [<temp],y
1156 4783 A8                    tay   
1157 4784 A7 1F                 lda   [<temp]
1158 4786 85 1F                 sta   <temp
1159 4788 84 21                 sty   <temp+2
1160 478A              ;
1161 478A A0 12 00              ldy   #CtlValue                Set control's refcon to its value.
1162 478D B7 1F                 lda   [<temp],y                The refcon is used by TaskScroll
1163 478F A0 20 00              ldy   #CtlrefCon               is call for dragged thumber.  The
1164 4792 97 1F                 sta   [<temp],y                refcon is the old position.
1165 4794 60                    rts   
1166 4795              ;
1167 4795              ;
1168 4795              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1169 4795              ;          Move a long value from the
1170 4795              ;          parameter list into the window record.
1171 4795              ;430= = = = = = = = = = = = = = = = = = = = = = = = = = = =
1172 4795              ;
1173 4795              ;   IN:    w_param = pointer to parameter list.
1174 4795              ;          w_wind = pointer to window record.
1175 4795              ;          y = index to LOW word of value in parameter list.
1176 4795              ;          x = index to HIGH word of value in window record.
1177 4795              ;
1178 4795                       ENTRY setWindField 
1179 4795              setWindField                            ;       
1180 4795              ;
1181 4795 B7 40                 lda   [<w_param],y
1182 4797 48                    pha   
1183 4798 C8                    iny   
1184 4799 C8                    iny   
1185 479A B7 40                 lda   [<w_param],y
1186 479C 9B                    txy   
1187 479D 97 44                 sta   [<w_wind],y
1188 479F 88                    dey   
1189 47A0 88                    dey   
1190 47A1 68                    pla   
1191 47A2 97 44                 sta   [<w_wind],y
1192 47A4 60                    rts   
1193 47A5              ;
1194 47A5              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1195 47A5              ;          Set width of title.
1196 47A5              ;440= = = = = = = = = = = = = = = = = = = = = = = = = = = =
1197 47A5              ;
1198 47A5              ;   IN:    <w_wind = pointer to window.
1199 47A5              ;          Pointer to title in wTitle field of window record.
1200 47A5              ;
1201 47A5              ;   OUT:   wTitle_w field of window record = width of window.
1202 47A5              ;
1203 47A5                       ENTRY setTitleWidth 
1204 47A5              setTitleWidth  
1205 47A5              ;
1206 47A5                       IMPORT pushWindTitle 
1207 47A5                       IMPORT unlockTitle 
1208 47A5              ;
1209 47A5 48                    pha                            Space for result.
1210 47A6 20 F4 54              jsr   pushWindTitle            Pass pointer to title.
1211 47A9 A2 04 A9 22           _StringWidth 
1212 47B0 68                    pla                            Set width of title in window record.
1213 47B1 A0 D8 00              ldy   #wTitle_w
1214 47B4 97 44                 sta   [<w_wind],y
1215 47B6              ;
1216 47B6 82 6D 0D              brl   unlockTitle              Leave title unlocked.
1217 47B9              ;
1218 47B9              ;
1219 47B9              ; = = = = = = = = = = = = = = = = = = = = = = = =
1220 47B9              ; 4        Draw grow outline of window.
1221 47B9              ;500= = = = = = = = = = = = = = = = = = = = = = =
1222 47B9              ;
1223 47B9              ;   IN: <w_wind = pointer to window to be closed.
1224 47B9              ;
1225 47B9              ;  OUT: x/a = NIL to continue close, else abort.
1226 47B9              ;
1227 47B9                       ENTRY docDispose 
1228 47B9 A0 D6 00     docDispose ldy   #wtitle+2              Was the title allocated?
1229 47BC B7 44                 lda   [<w_wind],y
1230 47BE 10 03                 bpl   @skip1
1231 47C0 20 CF 47              jsr   @dispose                 Free title.
1232 47C3              ;
1233 47C3 A0 E6 00     @skip1   ldy   #wColor+2                Was the color table allocated?
1234 47C6 B7 44                 lda   [<w_wind],y
1235 47C8 10 03                 bpl   @skip2
1236 47CA 20 CF 47              jsr   @dispose                 Free color table.
1237 47CD 80 11        @skip2   bra   docDrag                  Return NIL.
1238 47CF              ;
1239 47CF              ;
1240 47CF              ;-------------------------------------------------------------------
1241 47CF              ;                   Dispose of handle in window record.
1242 47CF              ;-------------------------------------------------------------------
1243 47CF              ;
1244 47CF 29 FF 7F     @dispose and   #$7FFF
1245 47D2 48                    pha   
1246 47D3 88                    dey   
1247 47D4 88                    dey   
1248 47D5 B7 44                 lda   [<w_wind],y
1249 47D7 48                    pha   
1250 47D8 A2 02 10 22           _DisposeHandle 
1251 47DF 60                    rts   
1252 47E0              ;
1253 47E0              ;
1254 47E0              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1255 47E0              ; 5        Return address of routine to draw window outline.
1256 47E0              ;510= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1257 47E0              ;
1258 47E0              ;  OUT:    x/a = result, zero for default outline.
1259 47E0              ;
1260 47E0              docDrag                                 ; 
1261 47E0              ;
1262 47E0 A9 00 00              lda   #0                       Return FALSE to continue disposal.
1263 47E3 AA                    tax   
1264 47E4 18                    clc                            No error flag.
1265 47E5 60                    rts   
1266 47E6              ;
1267 47E6              ;
1268 47E6              ; = = = = = = = = = = = = = = = = = = = = = = = =
1269 47E6              ; 6        Draw grow window outline.
1270 47E6              ;600= = = = = = = = = = = = = = = = = = = = = = =
1271 47E6              ;
1272 47E6              ;  OUT:    x/a = result.
1273 47E6              ;
1274 47E6              docGrow                                 ; 
1275 47E6              ;
1276 47E6 A9 00 00              lda   #0                       Perform default action.
1277 47E9 AA                    tax   
1278 47EA 18                    clc                            No error flag.
1279 47EB 60                    rts   
1280 47EC              ;
1281 47EC              ;
1282 47EC              ; = = = = = = = = = = = = = = = = = = = = = = = =
1283 47EC              ; 7        Return window record size.
1284 47EC              ;610= = = = = = = = = = = = = = = = = = = = = = =
1285 47EC              ;
1286 47EC              ;   IN:    <w_param = pointer to parameter table.
1287 47EC              ;
1288 47EC              ;  OUT:    a = additional bytes needed in window record.
1289 47EC              ;
1290 47EC                       ENTRY docRecSize 
1291 47EC              docRecSize                              ;       
1292 47EC              ;
1293 47EC A7 40                 lda   [<w_param]               Check length paramter.
1294 47EE C9 4E 00              cmp   #p_size                  Proper size?
1295 47F1 F0 05                 beq   ok610
1296 47F3              ;
1297 47F3 A0 01 0E              ldy   #$0E01                   Bad parameter list length error.
1298 47F6 38                    sec                            Error flag.
1299 47F7 60                    rts   
1300 47F8              ;
1301 47F8              ;
1302 47F8 A0 4B 00     ok610    ldy   #p_windrec+1             Has a record already been allocated?
1303 47FB B7 40                 lda   [<w_param],y
1304 47FD F0 23                 beq   ok611
1305 47FF C8                    iny   
1306 4800 B7 40                 lda   [<w_param],y             Return pointer to record.
1307 4802 09 00 80              ora   #$8000                   Make negative to say record is allocated.
1308 4805 AA                    tax   
1309 4806 88                    dey   
1310 4807 88                    dey   
1311 4808 B7 40                 lda   [<w_param],y
1312 480A
1313 480A              ;-----------------------------------------------------------
1314 480A              ;
1315 480A              ; Zero the record provided
1316 480A              ;
1317 480A DA                    phx   
1318 480B 48                    pha   
1319 480C 0B                    phd   
1320 480D 3B                    tsc   
1321 480E 5B                    tcd   
1322 480F
1323 480F A0 08 01              ldy   #DOCSIZE-2               Get size of record.(this includes the window
1324 4812 A9 00 00              lda   #0                       record header)
1325 4815 97 03        @loop    sta   [3],y
1326 4817 88                    dey   
1327 4818 88                    dey   
1328 4819 10 FA                 bpl   @loop
1329 481B 87 03                 sta   [3]                      In case it was not even
1330 481D              ;
1331 481D 2B                    pld   
1332 481E 68                    pla   
1333 481F FA                    plx   
1334 4820              ;
1335 4820 18                    clc   
1336 4821 60                    rts   
1337 4822              ;
1338 4822 A9 36 00     ok611    lda   #DOCSIZE-wtitle          Addtional bytes needed.
1339 4825 A2 00 00              ldx   #0
1340 4828 18                    clc                            No error flag.
1341 4829 60                    rts   
1342 482A              ;
1343 482A              ;
1344 482A              ; = = = = = = = = = = = = = = = = = = = = = = = =
1345 482A              ; 8        Return position and size of window.
1346 482A              ;620= = = = = = = = = = = = = = = = = = = = = = =
1347 482A              ;
1348 482A              ;   IN:    w_param = pointer to parameter table.
1349 482A              ;
1350 482A              ;  OUT:    x/a = pointer to RECT that is new window's position and size.
1351 482A              ;
1352 482A                       ENTRY docPosition 
1353 482A              docPosition                             ;       
1354 482A              ;
1355 482A A6 42                 ldx   <w_param+2               Return pointer to RECT in w_param list.
1356 482C A5 40                 lda   <w_param
1357 482E 18                    clc   
1358 482F 69 3E 00              adc   #p_position
1359 4832 90 01                 bcc   exit620
1360 4834 E8                    inx   
1361 4835              ;
1362 4835 18           exit620  clc                            No error flag.
1363 4836 60                    rts   
1364 4837              ;
1365 4837              ;
1366 4837              ; = = = = = = = = = = = = = = = = = = = = = = = =
1367 4837              ; 9        Return where window goes in list.
1368 4837              ;630= = = = = = = = = = = = = = = = = = = = = = =
1369 4837              ;
1370 4837              ;   IN:    w_param = pointer to parameter table.
1371 4837              ;
1372 4837              ;  OUT:    x/a = pointer to window this window should be behind, or
1373 4837              ;                $00000000 if this window should be bottom most, or
1374 4837              ;                $FFFFFFFF if this window should be top most.
1375 4837              ;
1376 4837                       ENTRY docBehind 
1377 4837              docBehind                               ;       
1378 4837              ;
1379 4837 A0 48 00              ldy   #p_behind+2              Return value in parameter list.
1380 483A B7 40                 lda   [<w_param],y
1381 483C AA                    tax   
1382 483D 88                    dey   
1383 483E 88                    dey   
1384 483F B7 40                 lda   [<w_param],y
1385 4841              ;
1386 4841 18                    clc                            No error flag.
1387 4842 60                    rts   
1388 4843              ;
1389 4843              ;
1390 4843              ; = = = = = = = = = = = = = = = = = = = = = = = =
1391 4843              ;        Get zoom box's coordinates.
1392 4843              ;750= = = = = = = = = = = = = = = = = = = = = = =
1393 4843              ;
1394 4843              ;   IN:    w_wind = window to check.
1395 4843              ;          w_wrect = window's coordinates, local to window.
1396 4843              ;
1397 4843              ;  OUT:    w_rect = zoom box's coordinates.
1398 4843              ;
1399 4843                       ENTRY getzoomcor 
1400 4843              getzoomcor                              ;       
1401 4843              ;
1402 4843 A5 0B                 lda   <w_wrect+x2
1403 4845 38                    sec   
1404 4846 E9 0A 00              sbc   #CLOSEL
1405 4849 85 13                 sta   <w_rect+x2
1406 484B 38                    sec   
1407 484C A0 08 00              ldy   #closeWidth
1408 484F F7 4A                 sbc   [<globals],y             Less width of icon font.
1409 4851 85 0F                 sta   <w_rect+x1
1410 4853              ;
1411 4853 80 0D                 bra   top_bottom               Compute top and bottom.
1412 4855              ;
1413 4855              ;
1414 4855              ; = = = = = = = = = = = = = = = = = = = = = = = =
1415 4855              ;        Get close box's coordinates.
1416 4855              ;760= = = = = = = = = = = = = = = = = = = = = = =
1417 4855              ;
1418 4855              ;   IN:  w_wind = pointer to window.
1419 4855              ;
1420 4855              ;  OUT:  w_rect = close box's coordinates.
1421 4855              ;
1422 4855                       ENTRY getclosecor 
1423 4855              getclosecor                             ;       
1424 4855              ;
1425 4855 A9 0A 00              lda   #CLOSEL
1426 4858 85 0F                 sta   <w_rect+x1
1427 485A 18                    clc   
1428 485B A0 08 00              ldy   #closeWidth
1429 485E 77 4A                 adc   [<globals],y             Add width of icon font.
1430 4860 85 13                 sta   <w_rect+x2
1431 4862              ;
1432 4862 A9 02 00     top_bottom lda   #CLOSET
1433 4865 85 0D                 sta   <w_rect+y1
1434 4867 18                    clc   
1435 4868 A0 06 00              ldy   #closeHeight
1436 486B 77 4A                 adc   [<globals],y             Add height of icon font.
1437 486D 85 11                 sta   <w_rect+y2
1438 486F              ;
1439 486F 60                    rts   
1440 4870              ;
1441 4870                       ENDP 
1442 4870              ;
1443 4870              ;            APPEND                     DOCCALL.ASM
1444 4870                       TITLE 'Apple IIGS Window Manager                   DOCCALL.ASM' 
1445 4870              ;
1446 4870              ;          Copyright Apple Computer, Inc. 1986
1447 4870              ;          All rights reserved
1448 4870              ;          Written by Dan Oliver
1449 4870              ;
1450 4870              ;
1451 4870              ;
1452 4870              ;============================================
1453 4870              ; 10       Generic call to defProc.
1454 4870              ;============================================
1455 4870              ;
1456 4870              ;   IN:    <w_wind = pointer to window record.
1457 4870              ;          <globals = pointer to Window Manager globals.
1458 4870              ;          <w_param = pointer to parameter table:
1459 4870              ;                      dRequest   WORD  operation.
1460 4870              ;                      defProcID  WORD  0 for this defProc.
1461 4870              ;                      newParam   LONG  possible new value to set.
1462 4870              ;
1463 4870              ;  OUT:    x/a = result.
1464 4870              ;
1465 4870              docCallDefProc PROC 
1466 4870              ;
1467 4870 A0 02 00              ldy   #defProcID               Is this a call to me?
1468 4873 B7 40                 lda   [<w_param],y
1469 4875 D0 18                 bne   exit1
1470 4877              ;
1471 4877 A7 40                 lda   [<w_param]               Get special operation number.
1472 4879 C9 22 00              cmp   #34                      In range?
1473 487C B0 11                 bcs   exit1
1474 487E              ;
1475 487E 0A                    asl   a
1476 487F AA                    tax   
1477 4880 BF 90 48 FD           lda   >specialOps,x
1478 4884 48                    pha   
1479 4885              ;
1480 4885 A0 06 00              ldy   #newParam+2
1481 4888 B7 40                 lda   [<w_param],y
1482 488A AA                    tax                            Pass high word of newParam in X.
1483 488B 88                    dey                            Pass y = to newParam offset.
1484 488C 88                    dey   
1485 488D B7 40                 lda   [<w_param],y             Pass low word of newParam in A.
1486 488F 60           exit1    rts                            Go to special op handler.
1487 4890              ;
1488 4890              ;
1489 4890 D3 48        specialOps DC W:hSetOrgMask-1           0
1490 4892 DA 48                 DC W:hSetMaxGrow-1             1
1491 4894 E3 48                 DC W:hSetScroll-1              2
1492 4896 EF 48                 DC W:hSetPage-1                3
1493 4898 F4 48                 DC W:hSetInfoRefCon-1          4
1494 489A F9 48                 DC W:hSetInfoDraw-1            5
1495 489C 05 49                 DC W:hSetOrigin-1              6
1496 489E A7 49                 DC W:hSetDataSize-1            7
1497 48A0 74 4B                 DC W:hSetZoomRect-1            8
1498 48A2 96 4B                 DC W:hSetTitle-1               9
1499 48A4 FE 4B                 DC W:hSetColorTable-1          10
1500 48A6 3A 4C                 DC W:hSetFrameFlag-1           11
1501 48A8 20 4B                 DC W:hGetOrgMask-1             12
1502 48AA 2A 4B                 DC W:hGetMaxGrow-1             13
1503 48AC 2F 4B                 DC W:hGetScroll-1              14
1504 48AE 34 4B                 DC W:hGetPage-1                15
1505 48B0 39 4B                 DC W:hGetInfoRefCon-1          16
1506 48B2 3E 4B                 DC W:hGetInfoDraw-1            17
1507 48B4 43 4B                 DC W:hGetOrigin-1              18
1508 48B6 68 4B                 DC W:hGetDataSize-1            19
1509 48B8 40 4C                 DC W:hGetZoomRect-1            20
1510 48BA 48 4B                 DC W:hGetTitle-1               21
1511 48BC 4D 4B                 DC W:hGetColorTable-1          22
1512 48BE 4C 4C                 DC W:hGetFrameFlag-1           23
1513 48C0 52 4C                 DC W:hGetInfoRect-1            24
1514 48C2 11 4D                 DC W:hDrawInfo-1               25
1515 48C4 9E 4C                 DC W:hStartInfoDraw-1          26
1516 48C6 30 4D                 DC W:hEndInfoDraw-1            27
1517 48C8 48 4D                 DC W:hZoomWindow-1             28
1518 48CA BC 4D                 DC W:hStartDrawing-1           29
1519 48CC DF 4D                 DC W:hStartMove-1              30
1520 48CE E7 4D                 DC W:ckZoom-1                  31
1521 48D0 1E 4E                 DC W:hNewSize-1                32
1522 48D2 D4 4E                 DC W:hTask-1                   33
1523 48D4              ;
1524 48D4                       ENDP 
1525 48D4              ;
1526 48D4              ;
1527 48D4              ;=======================================
1528 48D4              ;          Set origin mask.
1529 48D4              ;=======================================
1530 48D4              ;
1531 48D4              ;   IN:    a = new mask.
1532 48D4              ;          <w_wind = pointer to window record.
1533 48D4              ;
1534 48D4              hSetOrgMask PROC 
1535 48D4
1536 48D4 A0 DA 00              ldy   #worgn_mask
1537 48D7 97 44                 sta   [<w_wind],y
1538 48D9 18                    clc                            No error flag.
1539 48DA 60                    rts   
1540 48DB                       ENDP 
1541 48DB              ;
1542 48DB              ;
1543 48DB              ;=======================================
1544 48DB              ;          Set maximum grow size.
1545 48DB              ;=======================================
1546 48DB              ;
1547 48DB              ;   IN:    a = maximum window height.
1548 48DB              ;          x = maximum window width.
1549 48DB              ;
1550 48DB              hSetMaxGrow PROC 
1551 48DB
1552 48DB A0 F0 00              ldy   #wmaxHeight
1553 48DE 20 FD 48              jsr   setLong
1554 48E1 82 16 FE              brl   setDefFull               Check to set default max grow.
1555 48E4                       ENDP 
1556 48E4              ;
1557 48E4              ;
1558 48E4              ;=======================================
1559 48E4              ;          Set amount to scroll
1560 48E4              ;          when arrows selected.
1561 48E4              ;=======================================
1562 48E4              ;
1563 48E4              hSetScroll PROC 
1564 48E4
1565 48E4 A0 F4 00              ldy   #vscroll
1566 48E7              ;
1567 48E7 97 44        setLong  sta   [<w_wind],y
1568 48E9 C8                    iny   
1569 48EA C8                    iny   
1570 48EB 8A                    txa   
1571 48EC 97 44                 sta   [<w_wind],y
1572 48EE 18                    clc                            No error flag.
1573 48EF 60                    rts   
1574 48F0                       ENDP 
1575 48F0              ;
1576 48F0              ;
1577 48F0              ;
1578 48F0              ;=======================================
1579 48F0              ;          Set amount to scroll
1580 48F0              ;          when page region selected.
1581 48F0              ;=======================================
1582 48F0              ;
1583 48F0              hSetPage PROC 
1584 48F0
1585 48F0 A0 F8 00              ldy   #vpage
1586 48F3 80 08                 bra   setLong
1587 48F5                       ENDP 
1588 48F5              ;
1589 48F5              ;
1590 48F5              ;=======================================
1591 48F5              ;          Set info bar refCon.
1592 48F5              ;=======================================
1593 48F5              ;
1594 48F5              hSetInfoRefCon PROC 
1595 48F5
1596 48F5 A0 FC 00              ldy   #wInfoRef
1597 48F8 80 03                 bra   setLong
1598 48FA                       ENDP 
1599 48FA              ;
1600 48FA              ;
1601 48FA              ;=================================================
1602 48FA              ;          Set info bar draw procedure.
1603 48FA              ;=================================================
1604 48FA              ;
1605 48FA              hSetInfoDraw PROC 
1606 48FA
1607 48FA A0 06 01              ldy   #wInfoDraw
1608 48FD              ;
1609 48FD              ;
1610 48FD              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
1611 48FD              ;          Set a long value in window record.
1612 48FD              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
1613 48FD              ;
1614 48FD              ;   IN:    y = offset into window record of field to set.
1615 48FD              ;          a = low word of long value.
1616 48FD              ;          x = high word of long value.
1617 48FD              ;          w_wind = pointer to window record.
1618 48FD              ;
1619 48FD              ;  OUT:    Carry clear, no error.
1620 48FD              ;
1621 48FD                       ENTRY setLong 
1622 48FD              setLong                                 ;       
1623 48FD              ;
1624 48FD 97 44                 sta   [<w_wind],y
1625 48FF C8                    iny   
1626 4900 C8                    iny   
1627 4901 8A                    txa   
1628 4902 97 44                 sta   [<w_wind],y
1629 4904              ;
1630 4904 18                    clc                            No error flag.
1631 4905 60                    rts   
1632 4906              ;
1633 4906                       ENDP 
1634 4906              ;
1635 4906              ;
1636 4906              ;=======================================
1637 4906              ;          Set content's origin.
1638 4906              ;=======================================
1639 4906              ;
1640 4906              ;   IN:    <w_param+newParam = WORD new Y origin.
1641 4906              ;                            WORD new X origin.
1642 4906              ;                            WORD flag.
1643 4906              ;          a = new y origin.
1644 4906              ;          x = new x origin.
1645 4906              ;
1646 4906              hSetOrigin PROC 
1647 4906              ;
1648 4906                                                      ;using equates
1649 4906              ;
1650 4906              newYorigin equ   w_work
1651 4906              newXorigin equ   newYorigin+2
1652 4906              temp1    equ   newXorigin+2
1653 4906              temp2    equ   temp1+4
1654 4906              matchID  equ   temp2+4
1655 4906              ;
1656 4906              ;
1657 4906 85 15                 sta   <newYorigin              Save new Y origin.
1658 4908 86 17                 stx   <newXorigin              Save new X origin.
1659 490A              ;
1660 490A A0 08 00              ldy   #newParam+4
1661 490D B7 40                 lda   [<w_param],y
1662 490F F0 05                 beq   skip1                    Should content be scrolled?
1663 4911              ;
1664 4911              ;
1665 4911              ; --- Scroll content to new origin ---------------------------
1666 4911              ;
1667 4911 20 23 49              jsr   scrollContent
1668 4914 18                    clc                            No error flag.
1669 4915 60                    rts   
1670 4916
1671 4916              ;
1672 4916              ;
1673 4916              ; --- Set new origin without scrolling content ---------------
1674 4916              ;
1675 4916 A5 15        skip1    lda   <newYorigin              Pass new Y origin in A, new X in X.
1676 4918 A0 E8 00              ldy   #y_origin
1677 491B 20 FD 48              jsr   setLong
1678 491E              ;
1679 491E 20 2A 49              jsr   setScrollBars
1680 4921 18                    clc                            No error flag.
1681 4922 60                    rts   
1682 4923              ;
1683 4923              ; 
1684 4923              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
1685 4923              ;          Scroll content and set new origon.
1686 4923              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = =
1687 4923              ;
1688 4923              ;   IN:    New origin on stack.
1689 4923              ;
1690 4923              scrollContent                           ; 
1691 4923              ; 
1692 4923 A6 17                 ldx   <newXorigin
1693 4925 A5 15                 lda   <newYorigin
1694 4927 20 21 4A              jsr   new_origin
1695 492A              ;
1696 492A              ;
1697 492A              ;--------------------------------------------------------------------
1698 492A              ;          Set the frame scroll bars to reflect the change.
1699 492A              ;--------------------------------------------------------------------
1700 492A              ;
1701 492A              setScrollBars                           ; 
1702 492A              ;
1703 492A 20 C5 50              jsr   startFrameDraw
1704 492D              ;
1705 492D              ;
1706 492D              ; --- Set horizontal scroll bar ------------------------------
1707 492D              ;
1708 492D A9 06 00              lda   #HScrollID               Get handle of horizontal scroll bar.
1709 4930 20 6A 49              jsr   findCtlHand
1710 4933 B0 15                 bcs   skip100                  Is there a horizontal scroll bar?
1711 4935              ;
1712 4935 D4 17                 pei   <newXorigin              Pass new value.
1713 4937 DA                    phx                            Pass handle of control.
1714 4938 48                    pha   
1715 4939 A2 10 19 22           _SetCtlValue 
1716 4940              ;
1717 4940 20 9C 49              jsr   derefTemp1               <temp2 = (<temp1).
1718 4943 A5 17                 lda   <newXorigin              Get control's new value.
1719 4945 A0 20 00              ldy   #CtlrefCon
1720 4948 97 1D                 sta   [<temp2],y               Remeber value for scrolling.
1721 494A              ;
1722 494A              ;
1723 494A              ; --- Set vertical scroll bar --------------------------------
1724 494A              ;
1725 494A A9 04 00     skip100  lda   #VScrollID               Get handle of vertical scroll bar.
1726 494D 20 6A 49              jsr   findCtlHand
1727 4950 B0 15                 bcs   exit100                  Is there a vertical scroll bar?
1728 4952              ;
1729 4952 D4 15                 pei   <newYorigin              Pass new value.
1730 4954 DA                    phx                            Pass handle of control.
1731 4955 48                    pha   
1732 4956 A2 10 19 22           _SetCtlValue 
1733 495D              ;
1734 495D 20 9C 49              jsr   derefTemp1               <temp2 = (<temp1).
1735 4960 A5 15                 lda   <newYorigin              Get control's new value.
1736 4962 A0 20 00              ldy   #CtlrefCon
1737 4965 97 1D                 sta   [<temp2],y               Remeber value for scrolling.
1738 4967              ;
1739 4967 82 67 07     exit100  brl   endFrameDraw
1740 496A              ;
1741 496A              ;
1742 496A              ;
1743 496A              ; = = = = = = = = = = = = = = = = = = = = = = = =
1744 496A              ;          Push handle of first control.
1745 496A              ;110= = = = = = = = = = = = = = = = = = = = = = =
1746 496A              ;
1747 496A              ;   IN:    <w_wind = pointer to window that has frame controls.
1748 496A              ;          a = ID of control to find.
1749 496A              ;
1750 496A              ;  OUT:    Carry set if control not found.
1751 496A              ;          Carry clear if control found, x/a = handle of control.
1752 496A              ;
1753 496A                       ENTRY findCtlHand 
1754 496A              findCtlHand                             ;       
1755 496A              ;
1756 496A 85 21                 sta   <matchID                 Save ID to match.
1757 496C              ;
1758 496C A0 D0 00              ldy   #wFrameCtls+2            Get handle of first control.
1759 496F B7 44                 lda   [<w_wind],y
1760 4971 AA                    tax   
1761 4972 88                    dey   
1762 4973 88                    dey   
1763 4974 B7 44                 lda   [<w_wind],y
1764 4976 80 14                 bra   enter110
1765 4978              ;
1766 4978 20 9C 49     lop110   jsr   derefTemp1               <temp2 = (<temp1).
1767 497B              ;
1768 497B A0 22 00              ldy   #ctlRefCon+2             Get control's ID.
1769 497E B7 1D                 lda   [<temp2],y
1770 4980 C5 21                 cmp   <matchID
1771 4982 F0 12                 beq   gotit110
1772 4984              ;
1773 4984 A0 02 00              ldy   #ctlNext+2               Get handle of next control.
1774 4987 B7 1D                 lda   [<temp2],y
1775 4989 AA                    tax   
1776 498A A7 1D                 lda   [<temp2]
1777 498C              ;
1778 498C 85 19        enter110 sta   <temp1                   Store handle of control.
1779 498E 86 1B                 stx   <temp1+2
1780 4990 05 1B                 ora   <temp1+2                 Any more controls?
1781 4992 D0 E4                 bne   lop110
1782 4994 38                    sec                            Control not found.
1783 4995 60                    rts   
1784 4996              ;
1785 4996 A5 19        gotit110 lda   <temp1                   Return handle of control.
1786 4998 A6 1B                 ldx   <temp1+2
1787 499A 18                    clc                            Control found flag.
1788 499B 60                    rts   
1789 499C              ;
1790 499C              ;
1791 499C              ; = = = = = = = = = = = = = = = = = = = = = = = =
1792 499C              ;          Dereference <temp1.
1793 499C              ;120= = = = = = = = = = = = = = = = = = = = = = =
1794 499C              ;
1795 499C              ;   IN:    <temp1 =  handle.
1796 499C              ;
1797 499C              ;  OUT:    <temp2 = (temp1)
1798 499C              ;
1799 499C A0 02 00     derefTemp1 ldy   #2
1800 499F B7 19                 lda   [<temp1],y
1801 49A1 85 1F                 sta   <temp2+2
1802 49A3 A7 19                 lda   [<temp1]
1803 49A5 85 1D                 sta   <temp2
1804 49A7 60                    rts   
1805 49A8              ;
1806 49A8              ;
1807 49A8              ; = = = = = = = = = = = = = = = = = = = = =
1808 49A8              ;          Set window's data size.
1809 49A8              ;200= = = = = = = = = = = = = = = = = = = =
1810 49A8              ;
1811 49A8              ;   IN:    <w_param+newParam = new height of data area.
1812 49A8              ;          <w_param+newParam+2 = new width of data area.
1813 49A8              ;
1814 49A8                       ENTRY hSetDataSize 
1815 49A8              hSetDataSize                            ;       
1816 49A8              ;
1817 49A8              newHeight equ   newYorigin
1818 49A8              newWidth equ   newXorigin
1819 49A8              ;
1820 49A8              ;
1821 49A8 29 FF 3F              and   #$3FFF                   Limit new data size.
1822 49AB 85 15                 sta   <newHeight
1823 49AD 8A                    txa   
1824 49AE 29 FF 3F              and   #$3FFF
1825 49B1 85 17                 sta   <newWidth
1826 49B3              ;
1827 49B3 20 C5 50              jsr   startFrameDraw
1828 49B6              ;
1829 49B6              ;
1830 49B6              ; --- Set vertical scroll bar --------------------------------
1831 49B6              ;
1832 49B6 A9 04 00              lda   #VScrollID               Get handle of vertical scroll bar.
1833 49B9 20 6A 49              jsr   findCtlHand
1834 49BC B0 2B                 bcs   skip200                  Is there a vertical scroll bar?
1835 49BE              ;                                       <temp1 = control's handle.
1836 49BE              ;                                       <temp2 = control's pointer.
1837 49BE              ;
1838 49BE A0 12 00              ldy   #ctlValue                Compute maximum data size.
1839 49C1 B7 1D                 lda   [<temp2],y               Origin,
1840 49C3 A0 1C 00              ldy   #ctlData                 plus view,
1841 49C6 18                    clc   
1842 49C7 77 1D                 adc   [<temp2],y               equals minimum.
1843 49C9 C5 15                 cmp   <newHeight
1844 49CB 90 02                 bcc   ok200
1845 49CD              ;
1846 49CD 85 15                 sta   <newHeight               Reset data height to minimum.
1847 49CF              ;
1848 49CF A0 EC 00     ok200    ldy   #data_h                  Change the data width in the window.
1849 49D2 A5 15                 lda   <newHeight
1850 49D4 D7 44                 cmp   [<w_wind],y              Has there been a change?
1851 49D6 F0 11                 beq   skip200                  If no change, don't call control.
1852 49D8 97 44                 sta   [<w_wind],y              Store new data width in window record.
1853 49DA              ;
1854 49DA 48                    pha                            Pass new data size to scroll bar.
1855 49DB F4 FF FF              pea   $FFFF                    Don't change view.
1856 49DE D4 1B                 pei   <temp1+2                 Pass handle of scroll bar.
1857 49E0 D4 19                 pei   <temp1
1858 49E2 A2 10 1B 22           _SetCtlParams 
1859 49E9              ;
1860 49E9              ;
1861 49E9              ;
1862 49E9              ; --- Set horizontal scroll bar ------------------------------
1863 49E9              ;
1864 49E9 A9 06 00     skip200  lda   #HScrollID               Get handle of horizontal scroll bar.
1865 49EC 20 6A 49              jsr   findCtlHand
1866 49EF B0 2B                 bcs   exit200                  Is there a horizontal scroll bar?
1867 49F1              ;                                       <temp1 = control's handle.
1868 49F1              ;                                       <temp2 = control's pointer.
1869 49F1              ;
1870 49F1 A0 12 00              ldy   #ctlValue                Compute maximum data size.
1871 49F4 B7 1D                 lda   [<temp2],y               Origin,
1872 49F6 A0 1C 00              ldy   #ctlData                 plus view,
1873 49F9 18                    clc   
1874 49FA 77 1D                 adc   [<temp2],y               equals minimum.
1875 49FC C5 17                 cmp   <newWidth
1876 49FE 90 02                 bcc   ok201
1877 4A00              ;
1878 4A00 85 17                 sta   <newWidth                Reset data width to minimum.
1879 4A02              ;
1880 4A02 A0 EE 00     ok201    ldy   #data_w                  Change the data width in the window.
1881 4A05 A5 17                 lda   <newWidth
1882 4A07 D7 44                 cmp   [<w_wind],y              Has there been a change?
1883 4A09 F0 11                 beq   exit200                  If no change, don't call control.
1884 4A0B 97 44                 sta   [<w_wind],y              Store new data width in window record.
1885 4A0D              ;
1886 4A0D 48                    pha                            Pass new data size to scroll bar.
1887 4A0E F4 FF FF              pea   $FFFF                    Don't change view.
1888 4A11 D4 1B                 pei   <temp1+2                 Pass handle of scroll bar.
1889 4A13 D4 19                 pei   <temp1
1890 4A15 A2 10 1B 22           _SetCtlParams 
1891 4A1C              ;
1892 4A1C              ;
1893 4A1C 20 D1 50     exit200  jsr   endFrameDraw
1894 4A1F 18                    clc                            No error flag.
1895 4A20 60                    rts   
1896 4A21              ;
1897 4A21                       ENDP 
1898 4A21              ;
1899 4A21              ;
1900 4A21              ;=============================================
1901 4A21              ;          Change window's origin,
1902 4A21              ;          and scroll content.
1903 4A21              ;=============================================
1904 4A21              ;
1905 4A21              ;   IN:    a = new y origin.
1906 4A21              ;          x = new x origin.
1907 4A21              ;          w_wind = window pointer.
1908 4A21              ;
1909 4A21              ;
1910 4A21              ; Change History
1911 4A21              ;
1912 4A21              ; 21 May 89         Steven Glass
1913 4A21              ;
1914 4A21              ; Dispose of the temp region at exit time so it is not orphaned
1915 4A21              ; when the user has his own draw proc.
1916 4A21              ;
1917 4A21              new_origin PROC 
1918 4A21              ;
1919 4A21              ;
1920 4A21              newYorigin equ   w_work
1921 4A21              newXorigin equ   newyorigin+2
1922 4A21              tempRgn  equ   newXorigin+2
1923 4A21              deltay   equ   tempRgn+4
1924 4A21              deltax   equ   deltay+2
1925 4A21              ;
1926 4A21              ;
1927 4A21 85 15                 sta   <newYorigin              Save new y origin.
1928 4A23              ;
1929 4A23 8A                    txa                            Force x origin to grid.
1930 4A24 A0 DA 00              ldy   #worgn_mask
1931 4A27 37 44                 and   [<w_wind],y
1932 4A29 85 17                 sta   <newXorigin              Save new x origin.
1933 4A2B              ;
1934 4A2B              ;
1935 4A2B              ; --- Compute deltas -----------------------------------------
1936 4A2B              ;
1937 4A2B A0 EA 00              ldy   #x_origin
1938 4A2E B7 44                 lda   [<w_wind],y
1939 4A30 38                    sec   
1940 4A31 E5 17                 sbc   <newXorigin
1941 4A33 85 1F                 sta   <deltax                  Horizontal change.
1942 4A35 A5 17                 lda   <newXorigin              Set new origin.
1943 4A37 97 44                 sta   [<w_wind],y
1944 4A39 88                    dey   
1945 4A3A 88                    dey   
1946 4A3B B7 44                 lda   [<w_wind],y
1947 4A3D 38                    sec   
1948 4A3E E5 15                 sbc   <newYorigin
1949 4A40 85 1D                 sta   <deltay                  Vertical change.
1950 4A42 A5 15                 lda   <newYorigin              Set new origin.
1951 4A44 97 44                 sta   [<w_wind],y
1952 4A46              ;
1953 4A46              ;
1954 4A46              ; --- Offset the current update region to the new position ---------------
1955 4A46              ;
1956 4A46 A0 C8 00              ldy   #wupdateRgn+2            Pass handle to window's update region.
1957 4A49 20 B7 53              jsr   pushWindLong
1958 4A4C D4 1F                 pei   <deltax
1959 4A4E D4 1D                 pei   <deltay
1960 4A50 A2 04 6F 22           _OffsetRgn 
1961 4A57              ;
1962 4A57              ;
1963 4A57              ; --- Scroll the window's content region -------------------------------
1964 4A57              ;
1965 4A57 48                    pha                            Space for result.
1966 4A58 48                    pha   
1967 4A59 A2 04 67 22           _NewRgn                        Allocate a temp. region.
1968 4A60 68                    pla   
1969 4A61 85 19                 sta   <tempRgn
1970 4A63 68                    pla   
1971 4A64 85 1B                 sta   <tempRgn+2
1972 4A66              ;
1973 4A66              ;
1974 4A66              ; --- Scroll the content -------------------------------------
1975 4A66              ;
1976 4A66 48                    pha                            Save current port.
1977 4A67 48                    pha   
1978 4A68 A2 04 1C 22           _GetPort 
1979 4A6F              ;
1980 4A6F 20 BD 4D              jsr   hStartDrawing            Switch to window's content.
1981 4A72              ;
1982 4A72 A6 46                 ldx   <w_wind+2                Compute address of window's port,
1983 4A74 A5 44                 lda   <w_wind                  which is RECT to scroll.
1984 4A76 18                    clc   
1985 4A77 69 14 00              adc   #wPort+GP_PortRect       (Port RECT is local to content.)
1986 4A7A 90 01                 bcc   store1
1987 4A7C E8                    inx   
1988 4A7D DA           store1   phx                            Pass pointer to RECT to scroll.
1989 4A7E 48                    pha   
1990 4A7F D4 1F                 pei   <deltax
1991 4A81 D4 1D                 pei   <deltay
1992 4A83 D4 1B                 pei   <tempRgn+2               Update region to fill.
1993 4A85 D4 19                 pei   <tempRgn
1994 4A87 A2 04 7E 22           _ScrollRect 
1995 4A8E              ;
1996 4A8E A0 B7 00              ldy   #wContDraw+1             Is there a routine that will update
1997 4A91 B7 44                 lda   [<w_wind],y              the content?
1998 4A93 D0 42                 bne   redrawClobbered          If yes, redraw exposed area.
1999 4A95              ;
2000 4A95              ;
2001 4A95              ; --- Add clobbered region from scroll to window's update region ----------
2002 4A95              ;
2003 4A95 D4 1B                 pei   <tempRgn+2
2004 4A97 D4 19                 pei   <tempRgn
2005 4A99 A0 0E 00              ldy   #wPort+boundsRect+x1
2006 4A9C B7 44                 lda   [<w_wind],y
2007 4A9E 49 FF FF              eor   #$FFFF
2008 4AA1 1A                    inc   a
2009 4AA2 48                    pha   
2010 4AA3 88                    dey   
2011 4AA4 88                    dey   
2012 4AA5 B7 44                 lda   [<w_wind],y
2013 4AA7 49 FF FF              eor   #$FFFF
2014 4AAA 1A                    inc   a
2015 4AAB 48                    pha   
2016 4AAC A2 04 6F 22           _OffsetRgn                     Make clobbered area global.
2017 4AB3              ;
2018 4AB3 D4 1B                 pei   <tempRgn+2               Clobbered region.
2019 4AB5 D4 19                 pei   <tempRgn
2020 4AB7 A0 C8 00              ldy   #wupdateRgn+2            Add clobbered to update region.
2021 4ABA 20 B7 53              jsr   pushWindLong
2022 4ABD A0 C8 00              ldy   #wupdateRgn+2
2023 4AC0 20 B7 53              jsr   pushWindLong
2024 4AC3 A2 04 72 22           _UnionRgn 
2025 4ACA              ;
2026 4ACA D4 1B                 pei   <tempRgn+2               Free temp. region.
2027 4ACC D4 19                 pei   <tempRgn
2028 4ACE A2 04 68 22           _DisposeRgn 
2029 4AD5              ;
2030 4AD5 80 3F                 bra   exit
2031 4AD7              ;
2032 4AD7              ;
2033 4AD7              ; --- Refresh part that was exposed by scroll -----------------
2034 4AD7              ;
2035 4AD7              redrawClobbered                         ; 
2036 4AD7              ;
2037 4AD7 A0 22 00              ldy   #wport+visRgn+2          Save window's current visRgn.
2038 4ADA B7 44                 lda   [<w_wind],y
2039 4ADC 48                    pha   
2040 4ADD A5 1B                 lda   <tempRgn+2               Replace visRgn with clobbered region.
2041 4ADF 97 44                 sta   [<w_wind],y
2042 4AE1 88                    dey   
2043 4AE2 88                    dey   
2044 4AE3 B7 44                 lda   [<w_wind],y
2045 4AE5 48                    pha   
2046 4AE6 A5 19                 lda   <tempRgn
2047 4AE8 97 44                 sta   [<w_wind],y
2048 4AEA              ;
2049 4AEA              ;
2050 4AEA A0 B7 00              ldy   #wContDraw+1             Get address of content draw routine.
2051 4AED B7 44                 lda   [<w_wind],y
2052 4AEF AA                    tax   
2053 4AF0 88                    dey   
2054 4AF1 B7 44                 lda   [<w_wind],y
2055 4AF3              ;
2056 4AF3 0B                    phd                            Save my zero page.
2057 4AF4 8B                    phb                            Save current data bank.
2058 4AF5 48                    pha                            Save.
2059 4AF6              ;
2060 4AF6 A0 36 00              ldy   #callerDataB             Get caller's data bank pointer,
2061 4AF9 B7 4A                 lda   [<globals],y
2062 4AFB 48                    pha                            and switch to it.
2063 4AFC AB                    plb   
2064 4AFD AB                    plb   
2065 4AFE A0 34 00              ldy   #callerDpage             Get original direct page,
2066 4B01 B7 4A                 lda   [<globals],y
2067 4B03 5B                    tcd                            and switch to caller's direct page.
2068 4B04              ;
2069 4B04 68                    pla                            Restore.
2070 4B05 22 67 22 FD           jsl   longCall
2071 4B09              ;
2072 4B09 AB                    plb                            Restore last data bank.
2073 4B0A 2B                    pld                            Restore my direct page pointer.
2074 4B0B              ;
2075 4B0B A0 20 00              ldy   #wport+visRgn            Restore window's original visRgn.
2076 4B0E 68                    pla   
2077 4B0F 97 44                 sta   [<w_wind],y
2078 4B11 C8                    iny   
2079 4B12 C8                    iny   
2080 4B13 68                    pla   
2081 4B14 97 44                 sta   [<w_wind],y
2082 4B16              ;
2083 4B16              exit      
2084 4B16 20 6E 22              jsr   zeroOrigin               Return window's origin to 0,0.
2085 4B19 A2 04 1B 22           _SetPort                       Restore original port.
2086 4B20 60                    rts   
2087 4B21                       ENDP 
2088 4B21              ;
2089 4B21              ;
2090 4B21              ;=======================================
2091 4B21              ;          Return origin mask.
2092 4B21              ;=======================================
2093 4B21              ;
2094 4B21              hGetOrgMask PROC 
2095 4B21
2096 4B21 A0 DA 00              ldy   #worgn_mask
2097 4B24 B7 44                 lda   [<w_wind],y
2098 4B26 A2 00 00              ldx   #0
2099 4B29 18                    clc   
2100 4B2A 60                    rts   
2101 4B2B                       ENDP 
2102 4B2B              ;
2103 4B2B              ;
2104 4B2B              ;=======================================
2105 4B2B              ;          Return maximum grow size.
2106 4B2B              ;=======================================
2107 4B2B              ;
2108 4B2B              hGetMaxGrow PROC 
2109 4B2B
2110 4B2B A0 F2 00              ldy   #wmaxheight+2
2111 4B2E 80 3C                 bra   getLong
2112 4B30                       ENDP 
2113 4B30              ;
2114 4B30              ;
2115 4B30              ;=============================================
2116 4B30              ;          Return amount to scroll
2117 4B30              ;          when arrows are selected.
2118 4B30              ;=============================================
2119 4B30              ;
2120 4B30              hGetScroll PROC 
2121 4B30
2122 4B30 A0 F6 00              ldy   #vscroll+2
2123 4B33 80 37                 bra   getLong
2124 4B35                       ENDP 
2125 4B35              ;
2126 4B35              ;
2127 4B35              ;=============================================
2128 4B35              ;          Return amount to scroll
2129 4B35              ;          when page regions are selected.
2130 4B35              ;=============================================
2131 4B35              ;
2132 4B35              hGetPage PROC 
2133 4B35
2134 4B35 A0 FA 00              ldy   #vpage+2
2135 4B38 80 32                 bra   getLong
2136 4B3A                       ENDP 
2137 4B3A              ;
2138 4B3A              ;
2139 4B3A              ;==============================================
2140 4B3A              ;          Return info bar's refCon.
2141 4B3A              ;==============================================
2142 4B3A              ;
2143 4B3A              hGetInfoRefCon PROC 
2144 4B3A
2145 4B3A A0 FE 00              ldy   #wInfoRef+2
2146 4B3D 80 2D                 bra   getLong
2147 4B3F                       ENDP 
2148 4B3F              ;
2149 4B3F              ;
2150 4B3F              ;==============================================
2151 4B3F              ;          Return address of info
2152 4B3F              ;          bar's draw procedure.
2153 4B3F              ;==============================================
2154 4B3F              ;
2155 4B3F              hGetInfoDraw PROC 
2156 4B3F
2157 4B3F A0 08 01              ldy   #wInfoDraw+2
2158 4B42 80 28                 bra   getLong
2159 4B44                       ENDP 
2160 4B44              ;
2161 4B44              ;
2162 4B44              ;==============================================
2163 4B44              ;          Return content's origin.
2164 4B44              ;==============================================
2165 4B44              ;
2166 4B44              hGetOrigin PROC 
2167 4B44
2168 4B44 A0 EA 00              ldy   #y_origin+2
2169 4B47 80 23                 bra   getLong
2170 4B49                       ENDP 
2171 4B49              ;
2172 4B49              ;
2173 4B49              ;========================================================
2174 4B49              ;          Return pointer to window's title.
2175 4B49              ;========================================================
2176 4B49              ;
2177 4B49              hGetTitle PROC 
2178 4B49
2179 4B49 A0 D6 00              ldy   #wTitle+2
2180 4B4C 80 1E                 bra   getLong
2181 4B4E                       ENDP 
2182 4B4E              ;
2183 4B4E              ;
2184 4B4E              ;========================================================
2185 4B4E              ;          Return pointer to window's color table.
2186 4B4E              ;========================================================
2187 4B4E              ;
2188 4B4E              ;  OUT:    x/a = pointer or handle of window's color table (never null).  High bit set if handle.
2189 4B4E              ;
2190 4B4E              hGetColorTable PROC 
2191 4B4E              ;
2192 4B4E A0 E6 00              ldy   #wcolor+2                Fetch color table field from window record.
2193 4B51 B7 44                 lda   [<w_wind],y
2194 4B53 AA                    tax   
2195 4B54 88                    dey   
2196 4B55 88                    dey   
2197 4B56 B7 44                 lda   [<w_wind],y
2198 4B58 D0 0D                 bne   @exit                    Is the color table a pointer?
2199 4B5A 9B                    txy   
2200 4B5B D0 0A                 bne   @exit
2201 4B5D              ;
2202 4B5D              ;
2203 4B5D              ; --- NIL color table, use default.
2204 4B5D              ;
2205 4B5D A0 0C 00              ldy   #defWindClr+2            Use default color table.
2206 4B60 B7 4A                 lda   [<globals],y
2207 4B62 AA                    tax   
2208 4B63 88                    dey   
2209 4B64 88                    dey   
2210 4B65 B7 4A                 lda   [<globals],y
2211 4B67              ;
2212 4B67 18           @exit    clc                            No error flag.
2213 4B68 60                    rts   
2214 4B69                       ENDP 
2215 4B69              ;
2216 4B69              ;
2217 4B69              ;==============================================
2218 4B69              ;          Return window's data size.
2219 4B69              ;==============================================
2220 4B69              ;
2221 4B69              hGetDataSize PROC 
2222 4B69
2223 4B69 A0 EE 00              ldy   #data_h+2
2224 4B6C              ;
2225 4B6C              ;
2226 4B6C              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2227 4B6C              ;          Fetch a long value from a window record.
2228 4B6C              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2229 4B6C              ;
2230 4B6C              ;   IN:    y = offset to high word of long in window record.
2231 4B6C              ;          w_wind = pointer to window record.
2232 4B6C              ;
2233 4B6C              ;  OUT:    x/a = long fetched from window record.
2234 4B6C              ;          Carry clear, no error.
2235 4B6C              ;
2236 4B6C                       ENTRY getLong 
2237 4B6C              getLong                                 ;       
2238 4B6C              ;
2239 4B6C B7 44                 lda   [<w_wind],y
2240 4B6E AA                    tax   
2241 4B6F 88                    dey   
2242 4B70 88                    dey   
2243 4B71 B7 44                 lda   [<w_wind],y
2244 4B73              ;
2245 4B73 18                    clc                            No error flag.
2246 4B74 60                    rts   
2247 4B75                       ENDP 
2248 4B75              ;
2249 4B75              ;
2250 4B75              ;
2251 4B75              ;==============================================
2252 4B75              ;          Set new zoom RECT in window.
2253 4B75              ;==============================================
2254 4B75              ;
2255 4B75              ;   IN:    <w_wind = window to set zoom RECT in.
2256 4B75              ;          x/a = pointer to new zoom RECT.
2257 4B75              ;
2258 4B75              hSetZoomRect PROC 
2259 4B75              ;
2260 4B75                                                      ;using equates
2261 4B75              ;
2262 4B75              newZoom  equ   w_work
2263 4B75              temp1    equ   newZoom+4
2264 4B75              ;
2265 4B75              ;
2266 4B75 85 15                 sta   <newZoom                 Save pointer to new zoom RECT.
2267 4B77 86 17                 stx   <newZoom+2
2268 4B79              ;
2269 4B79 A0 D2 00              ldy   #wframe                  Reset zoomed flag.
2270 4B7C B7 44                 lda   [<w_wind],y
2271 4B7E 29 FD FF              and   #_F_ZOOMED               Clear zoomed bit.
2272 4B81 97 44                 sta   [<w_wind],y
2273 4B83              ;
2274 4B83              ;
2275 4B83              ; --- Move new zoom RECT into window record ------------------
2276 4B83              ;
2277 4B83 20 41 4C              jsr   hGetZoomRect             Compute address of wfull field.
2278 4B86 85 19                 sta   <temp1
2279 4B88 86 1B                 stx   <temp1+2
2280 4B8A              ;
2281 4B8A A0 06 00              ldy   #x2                      Move new RECT into window record.
2282 4B8D B7 15        lop1     lda   [<newZoom],y
2283 4B8F 97 19                 sta   [<temp1],y
2284 4B91 88                    dey   
2285 4B92 10 F9                 bpl   lop1
2286 4B94              ;
2287 4B94 82 63 FB              brl   setDefFull               Check to set default zoom RECT.
2288 4B97                       ENDP 
2289 4B97              ;
2290 4B97              ;
2291 4B97              ;==============================================
2292 4B97              ;          Change window's title.
2293 4B97              ;==============================================
2294 4B97              ;
2295 4B97              ;   IN:    <w_wind = pointer to window to set new title.
2296 4B97              ;          x/a = pointer to new title.
2297 4B97              ;
2298 4B97              hSetTitle PROC 
2299 4B97              ;
2300 4B97 DA                    phx                            Save title.
2301 4B98 48                    pha   
2302 4B99              ;
2303 4B99 A0 D6 00              ldy   #wtitle+2                Is there a handle there now?
2304 4B9C B7 44                 lda   [<w_wind],y
2305 4B9E 10 10                 bpl   @ok1
2306 4BA0 29 FF 7F              and   #$7FFF                   Free the exsisting handle first.
2307 4BA3 48                    pha   
2308 4BA4 88                    dey   
2309 4BA5 88                    dey   
2310 4BA6 B7 44                 lda   [<w_wind],y
2311 4BA8 48                    pha   
2312 4BA9 A2 02 10 22           _DisposeHandle 
2313 4BB0              ;
2314 4BB0 68           @ok1     pla                            Restore new title.
2315 4BB1 FA                    plx   
2316 4BB2              ;
2317 4BB2 A0 D4 00              ldy   #wtitle                  Store new title.
2318 4BB5 97 44                 sta   [<w_wind],y
2319 4BB7 C8                    iny   
2320 4BB8 C8                    iny   
2321 4BB9 8A                    txa   
2322 4BBA 97 44                 sta   [<w_wind],y
2323 4BBC              ;
2324 4BBC 20 C5 50              jsr   startFrameDraw
2325 4BBF 20 A5 47              jsr   setTitleWidth            Set the width of the new title.
2326 4BC2              ;
2327 4BC2 A9 00 00              lda   #titleBarID              Find title bar control.
2328 4BC5 20 6A 49              jsr   findCtlHand
2329 4BC8 B0 32                 bcs   exit                     Control found?
2330 4BCA              ;
2331 4BCA DA                    phx                            Pass handle of control to DrawOneCtl/
2332 4BCB 48                    pha   
2333 4BCC              ;
2334 4BCC 48                    pha                            Pass new value (not used).
2335 4BCD DA                    phx                            Pass handle of control to SetCtlValue.
2336 4BCE 48                    pha   
2337 4BCF A2 10 19 22           _SetCtlValue                   Have control compute title's x1 position.
2338 4BD6              ;
2339 4BD6 A0 D2 00              ldy   #wFrame                  Is the window visible?
2340 4BD9 B7 44                 lda   [<w_wind],y
2341 4BDB 29 20 00              and   #F_VIS
2342 4BDE D0 04                 bne   ok1                      If not, don't draw.
2343 4BE0 68                    pla                            Get rid of handle.
2344 4BE1 68                    pla   
2345 4BE2 80 18                 bra   exit                     And don't draw.
2346 4BE4              ;
2347 4BE4 A2 10 25 22  ok1      _DrawOneCtl                    Redraw the title bar.
2348 4BEB              ;
2349 4BEB              ;
2350 4BEB              ; --- Draw the info also, because system disk 3.1 and before did, some apps need this ---------------
2351 4BEB              ;
2352 4BEB A9 02 00              lda   #infoBarID               Find info bar control.
2353 4BEE 20 6A 49              jsr   findCtlHand
2354 4BF1 B0 09                 bcs   exit                     Control found?
2355 4BF3 DA                    phx                            Pass handle of info bar control.
2356 4BF4 48                    pha   
2357 4BF5 A2 10 25 22           _DrawOneCtl                    Draw the info bar.
2358 4BFC              ;
2359 4BFC 82 D2 04     exit     brl   endFrameDraw
2360 4BFF                       ENDP 
2361 4BFF              ;
2362 4BFF              ;
2363 4BFF              ;==============================================
2364 4BFF              ;          Change window's color table.
2365 4BFF              ;==============================================
2366 4BFF              ;
2367 4BFF              ;   IN:    <w_wind = pointer to window, zero to replace system table.
2368 4BFF              ;          x/a = pointer to new color table, zero to use default color table.
2369 4BFF              ;
2370 4BFF              hSetColorTable PROC 
2371 4BFF              ;
2372 4BFF A8                    tay                            Use default color table?
2373 4C00 D0 09                 bne   ok1
2374 4C02 9B                    txy   
2375 4C03 D0 06                 bne   ok1
2376 4C05 A9 31 4C              lda   #def_color               Use default color table.
2377 4C08 A2 FD 00              ldx   #def_color>>16
2378 4C0B              ;
2379 4C0B DA           ok1      phx                            Save new color table.
2380 4C0C 48                    pha   
2381 4C0D              ;
2382 4C0D A0 E6 00              ldy   #wColor+2                Is there a handle there now?
2383 4C10 B7 44                 lda   [<w_wind],y
2384 4C12 10 10                 bpl   @ok2
2385 4C14 29 FF 7F              and   #$7FFF                   Free the exsisting handle first.
2386 4C17 48                    pha   
2387 4C18 88                    dey   
2388 4C19 88                    dey   
2389 4C1A B7 44                 lda   [<w_wind],y
2390 4C1C 48                    pha   
2391 4C1D A2 02 10 22           _DisposeHandle 
2392 4C24              ;
2393 4C24 68           @ok2     pla                            Restore new color table.
2394 4C25 FA                    plx   
2395 4C26              ;
2396 4C26 A0 E4 00              ldy   #wColor                  Replace window's color table.
2397 4C29 97 44                 sta   [<w_wind],y
2398 4C2B C8                    iny   
2399 4C2C C8                    iny   
2400 4C2D 8A                    txa   
2401 4C2E 97 44                 sta   [<w_wind],y
2402 4C30              ;
2403 4C30 60           exit     rts   
2404 4C31              ;
2405 4C31              ;
2406 4C31              ; --- Default pattern/color table for windows ------------------
2407 4C31              ;
2408 4C31 00 00        def_color DC W:$0000                    Frame outline.
2409 4C33 0F 0F                 DC W:$0F0F                     Unused/Inactive Bar/Inactive Title/Title.
2410 4C35 00 00                 DC W:$0000                     Title bar.
2411 4C37 F0 F0                 DC W:$F0F0                     Inside grow box.
2412 4C39 F0 00                 DC W:$00F0                     Inside info bar.
2413 4C3B              ;
2414 4C3B                       ENDP 
2415 4C3B              ;
2416 4C3B              ;
2417 4C3B              ;==============================================
2418 4C3B              ;          Change window's frame flags.
2419 4C3B              ;==============================================
2420 4C3B              ;
2421 4C3B              ;   IN:    <w_wind = window pointer.
2422 4C3B              ;          a = new frame flag.
2423 4C3B              ;
2424 4C3B              hSetFrameFlag PROC 
2425 4C3B
2426 4C3B A0 D2 00              ldy   #wframe
2427 4C3E 97 44                 sta   [<w_wind],y
2428 4C40 60                    rts   
2429 4C41                       ENDP 
2430 4C41              ;
2431 4C41              ;
2432 4C41              ;===============================================================
2433 4C41              ;          Return pointer to window's zoom RECT field.
2434 4C41              ;===============================================================
2435 4C41              ;
2436 4C41              ;   IN:    <w_wind = window pointer.
2437 4C41              ;
2438 4C41              ;  OUT:    x/a = pointer to window's zoom RECT field.
2439 4C41              ;
2440 4C41              hGetZoomRect PROC 
2441 4C41
2442 4C41 A6 46                 ldx   <w_wind+2
2443 4C43 A5 44                 lda   <w_wind
2444 4C45 18                    clc   
2445 4C46 69 DC 00              adc   #wfull
2446 4C49 90 01                 bcc   exit
2447 4C4B E8                    inx   
2448 4C4C 60           exit     rts   
2449 4C4D                       ENDP 
2450 4C4D              ;
2451 4C4D              ;
2452 4C4D              ;==============================================
2453 4C4D              ;          Return window's frame flags.
2454 4C4D              ;==============================================
2455 4C4D              ;
2456 4C4D              ;   IN:    <w_wind = window pointer.
2457 4C4D              ;
2458 4C4D              ;  OUT:    a = window's frame flags.
2459 4C4D              ;
2460 4C4D              hGetFrameFlag PROC 
2461 4C4D
2462 4C4D A0 D2 00              ldy   #wframe
2463 4C50 B7 44                 lda   [<w_wind],y
2464 4C52 60                    rts   
2465 4C53                       ENDP 
2466 4C53              ;
2467 4C53              ;
2468 4C53              ;==============================================
2469 4C53              ;          Return info bar RECT.
2470 4C53              ;==============================================
2471 4C53              ;
2472 4C53              ;   IN:    <w_wind = window pointer.
2473 4C53              ;          x/a = place to store RECT.
2474 4C53              ;
2475 4C53              ;  OUT:    Carry clear if there is an info bar.
2476 4C53              ;
2477 4C53              hGetInfoRect PROC 
2478 4C53              ;
2479 4C53                                                      ;using equates
2480 4C53              ;
2481 4C53              desRect  equ   w_work
2482 4C53              ctlHand  equ   desRect+4
2483 4C53              srcRect  equ   ctlHand+4
2484 4C53              ;
2485 4C53              ;
2486 4C53 85 15                 sta   <desRect                 Place to store info bar RECT.
2487 4C55 86 17                 stx   <desRect+2
2488 4C57              ;
2489 4C57 A9 02 00              lda   #infoBarID               Pass ID of info bar control.
2490 4C5A 20 6A 49              jsr   findCtlHand              Get info bar control handle.
2491 4C5D B0 32                 bcs   zeroDesRect              Is there an info bar control?
2492 4C5F              ;
2493 4C5F 85 19                 sta   <ctlHand
2494 4C61 86 1B                 stx   <ctlHand+2
2495 4C63              ;
2496 4C63 A0 02 00              ldy   #2                       Dereference control handle.
2497 4C66 B7 19                 lda   [<ctlHand],y
2498 4C68 A8                    tay   
2499 4C69 A7 19                 lda   [<ctlHand]
2500 4C6B 18                    clc                            Compute pointer to ctlRect foeld.
2501 4C6C 69 08 00              adc   #ctlRect
2502 4C6F 90 01                 bcc   store1
2503 4C71 C8                    iny   
2504 4C72 85 1D        store1   sta   <srcRect
2505 4C74 84 1F                 sty   <srcRect+2
2506 4C76              ;
2507 4C76 A0 06 00              ldy   #x2
2508 4C79 B7 1D        lop1     lda   [<srcRect],y
2509 4C7B 97 15                 sta   [<desRect],y
2510 4C7D 88                    dey   
2511 4C7E 88                    dey   
2512 4C7F 10 F8                 bpl   lop1
2513 4C81              ;
2514 4C81 D4 17                 pei   <desRect+2               Pass pointer of destination RECT.
2515 4C83 D4 15                 pei   <desRect
2516 4C85 20 6E 54              jsr   pushLineSize             Pass size of lines.
2517 4C88 A2 04 4C 22           _InsetRect                     Return inside RECT of info bar.
2518 4C8F              ;
2519 4C8F 18                    clc                            There is an info bar.
2520 4C90 60                    rts   
2521 4C91              ;
2522 4C91              ;
2523 4C91              ; --- Zero destination RECT ----------------------------------
2524 4C91              ;
2525 4C91                       ENTRY zeroDesRect 
2526 4C91              zeroDesRect                             ;       
2527 4C91              ;
2528 4C91 A0 06 00              ldy   #x2
2529 4C94 A9 00 00              lda   #0
2530 4C97 97 15        lop2     sta   [<desRect],y
2531 4C99 88                    dey   
2532 4C9A 88                    dey   
2533 4C9B 10 FA                 bpl   lop2
2534 4C9D 38                    sec                            No info bar.
2535 4C9E 60                    rts   
2536 4C9F              ;
2537 4C9F                       ENDP 
2538 4C9F              ;
2539 4C9F              ;
2540 4C9F              ;===========================================================
2541 4C9F              ;          Setup to draw in window's info bar.
2542 4C9F              ;===========================================================
2543 4C9F              ;
2544 4C9F              ;   IN:    <w_wind = window pointer.
2545 4C9F              ;          x/a = pointer of where to store info bar RECT.
2546 4C9F              ;
2547 4C9F              hStartInfoDraw PROC 
2548 4C9F
2549 4C9F 20 53 4C              jsr   hGetInfoRect
2550 4CA2 B0 0D                 bcs   ok1                      Is there an info bar?
2551 4CA4              ;
2552 4CA4 A0 D2 00              ldy   #wframe                  Is the window visible?
2553 4CA7 B7 44                 lda   [<w_wind],y
2554 4CA9 29 20 00              and   #F_VIS
2555 4CAC D0 03                 bne   ok1
2556 4CAE 82 E0 FF              brl   zeroDesRect              Return zero RECT.
2557 4CB1              ;
2558 4CB1              ok1                                     ; 
2559 4CB1              ;
2560 4CB1              ;
2561 4CB1              ; --- Clip visRgn to window's above --------------------------
2562 4CB1              ;
2563 4CB1                       ENTRY clipVis 
2564 4CB1              clipVis                                 ;       
2565 4CB1              ;
2566 4CB1              clipVisRgn equ   w_work
2567 4CB1              windPtr  equ   clipVisRgn+4
2568 4CB1              ;
2569 4CB1 48                    pha   
2570 4CB2 48                    pha   
2571 4CB3 A2 0E 20 22           _GetWMgrPort 
2572 4CBA 68                    pla   
2573 4CBB 85 19                 sta   <windPtr
2574 4CBD 68                    pla   
2575 4CBE 85 1B                 sta   <windPtr+2
2576 4CC0              ;
2577 4CC0 A0 18 00              ldy   #clipRgn
2578 4CC3 B7 19                 lda   [<windPtr],y
2579 4CC5 85 15                 sta   <clipVisRgn
2580 4CC7 C8                    iny   
2581 4CC8 C8                    iny   
2582 4CC9 B7 19                 lda   [<windPtr],y
2583 4CCB 85 17                 sta   <clipVisRgn+2
2584 4CCD              ;
2585 4CCD 48                    pha   
2586 4CCE 48                    pha   
2587 4CCF A2 0E 15 22           _FrontWindow 
2588 4CD6 68                    pla   
2589 4CD7 FA                    plx   
2590 4CD8 38                    sec   
2591 4CD9 E9 04 00              sbc   #wPort
2592 4CDC B0 25                 bcs   enter1
2593 4CDE CA                    dex   
2594 4CDF 80 22                 bra   enter1
2595 4CE1              ;
2596 4CE1 D4 17        lop1     pei   <clipVisRgn+2            Pass region.
2597 4CE3 D4 15                 pei   <clipVisRgn
2598 4CE5 A0 C0 00              ldy   #wStrucRgn+2             Pass window's strucRgn to subtract.
2599 4CE8 B7 19                 lda   [<windPtr],y
2600 4CEA 48                    pha   
2601 4CEB 88                    dey   
2602 4CEC 88                    dey   
2603 4CED B7 19                 lda   [<windPtr],y
2604 4CEF 48                    pha   
2605 4CF0 D4 17                 pei   <clipVisRgn+2            Pass result region.
2606 4CF2 D4 15                 pei   <clipVisRgn
2607 4CF4 A2 04 73 22           _DiffRgn 
2608 4CFB              ;
2609 4CFB A0 02 00              ldy   #2                       Get pointer to next window.
2610 4CFE B7 19                 lda   [<windPtr],y
2611 4D00 AA                    tax   
2612 4D01 A7 19                 lda   [<windPtr]
2613 4D03              ;
2614 4D03 85 19        enter1   sta   <windPtr
2615 4D05 86 1B                 stx   <windPtr+2
2616 4D07              ;
2617 4D07 C5 44                 cmp   <w_wind
2618 4D09 D0 D6                 bne   lop1
2619 4D0B E4 46                 cpx   <w_wind+2
2620 4D0D D0 D2                 bne   lop1
2621 4D0F              ;
2622 4D0F 82 B3 03              brl   startFrameDraw
2623 4D12                       ENDP 
2624 4D12              ;
2625 4D12              ;
2626 4D12              ;============================================================
2627 4D12              ;          Redraw interior of window's info bar.
2628 4D12              ;============================================================
2629 4D12              ;
2630 4D12              hDrawInfo PROC 
2631 4D12
2632 4D12 A0 D2 00              ldy   #wFrame                  Is the window visible?
2633 4D15 B7 44                 lda   [<w_wind],y
2634 4D17 29 20 00              and   #F_VIS
2635 4D1A D0 01                 bne   ok1
2636 4D1C 60                    rts                            If invisible, don't draw.
2637 4D1D              ;
2638 4D1D 20 B1 4C     ok1      jsr   clipVis                  Set visRgn to clip windows above.
2639 4D20              ;
2640 4D20 A9 02 00              lda   #infoBarID               Pass ID of info bar control.
2641 4D23 20 6A 49              jsr   findCtlHand              Find handle of info bar control.
2642 4D26 B0 09                 bcs   skip1                    No info bar control?
2643 4D28              ;
2644 4D28 DA                    phx                            Pass handle of info bar control.
2645 4D29 48                    pha   
2646 4D2A A2 10 25 22           _DrawOneCtl                    Draw the info bar.
2647 4D31              ;
2648 4D31              skip1                                   ; 
2649 4D31              ;
2650 4D31              ;
2651 4D31              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2652 4D31              ;          Restore states after info bar draw.
2653 4D31              ;100= = = = = = = = = = = = = = = = = = = = = = = = = = = =
2654 4D31              ;
2655 4D31                       ENTRY hEndInfoDraw 
2656 4D31              hEndInfoDraw                            ;       
2657 4D31              ;
2658 4D31 F4 FD 00              pea   screenRect>>16           Restore Window Manager's clipRgn to full.
2659 4D34 F4 41 4D              pea   screenRect
2660 4D37 A2 04 26 22           _ClipRect 
2661 4D3E              ;
2662 4D3E 82 90 03              brl   endFrameDraw
2663 4D41              ;
2664 4D41 00 00 00 00  screenRect DC W:0,0,200,640
2665 4D49              ;
2666 4D49                       ENDP 
2667 4D49              ;
2668 4D49              ;
2669 4D49              ;=================================================
2670 4D49              ;          Flip a window's zoom position.
2671 4D49              ;=================================================
2672 4D49              ;
2673 4D49              ;   IN:    w_wind = window to zoom (or unzoom).
2674 4D49              ;
2675 4D49              ;  OUT:    None.
2676 4D49              ;
2677 4D49              hZoomWindow PROC 
2678 4D49
2679 4D49              ; --- Flip Full flag -------------------------------------------------
2680 4D49              ;
2681 4D49 A0 D2 00              ldy   #wframe                  Flip full window flag.
2682 4D4C B7 44                 lda   [<w_wind],y
2683 4D4E 49 02 00              eor   #F_ZOOMED
2684 4D51 97 44                 sta   [<w_wind],y
2685 4D53              ;
2686 4D53 29 02 00              and   #F_ZOOMED                Going to zoomed?
2687 4D56 D0 05                 bne   skip1
2688 4D58              ;
2689 4D58              ; --- Unzooming -------------
2690 4D58              ;
2691 4D58 20 00 4E              jsr   swap_origin              Replace old origin.
2692 4D5B 80 03                 bra   skip2
2693 4D5D              ;
2694 4D5D              ; --- Zooming ---------------
2695 4D5D              ;
2696 4D5D 20 8D 4D     skip1    jsr   saveWOrigin              Save current, unzoomed, origin.
2697 4D60              ;
2698 4D60              ;
2699 4D60              ; --- Swap Full RECT wth current content size ------------------------
2700 4D60              ;
2701 4D60 20 A2 4D     skip2    jsr   saveWRect
2702 4D63              ;
2703 4D63              ;
2704 4D63              ; --- Reset orgin if needed -------------------------------------------
2705 4D63              ;
2706 4D63 A5 13                 lda   <w_rect+x2
2707 4D65 38                    sec   
2708 4D66 E5 0F                 sbc   <w_rect+x1
2709 4D68 AA                    tax                            Pass content width in X.
2710 4D69              ;
2711 4D69 A5 11                 lda   <w_rect+y2
2712 4D6B 38                    sec   
2713 4D6C E5 0D                 sbc   <w_rect+y1               Pass content height in A.
2714 4D6E 20 48 4E              jsr   ck_origin                Check origin and reset if needed.
2715 4D71              ;
2716 4D71              ;
2717 4D71              ; --- Now resize and position window ----------------------------------
2718 4D71              ;
2719 4D71 F4 00 00              pea   0                        Redraw entire content region.
2720 4D74 20 B1 53              jsr   pushrect                 Pass pointer to new size of content.
2721 4D77 A6 46                 ldx   <w_wind+2                Pass pointer to graphPort.
2722 4D79 A5 44                 lda   <w_wind
2723 4D7B 18                    clc   
2724 4D7C 69 04 00              adc   #wPort
2725 4D7F 90 01                 bcc   store1
2726 4D81 E8                    inx   
2727 4D82 DA           store1   phx   
2728 4D83 48                    pha   
2729 4D84 A2 0E 5C 22           _ResizeWindow 
2730 4D8B              ;
2731 4D8B 18                    clc                            No error flag.
2732 4D8C 60                    rts   
2733 4D8D              ;
2734 4D8D              ;
2735 4D8D              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2736 4D8D              ;          Save window origin to its wold fields.
2737 4D8D              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2738 4D8D              ;
2739 4D8D              ;   IN:    w_wind = pointer to window.
2740 4D8D              ;
2741 4D8D              ;  OUT:    woldYOrg field = y_origin field.
2742 4D8D              ;          woldXOrg field = x_origin field.
2743 4D8D              ;
2744 4D8D                       ENTRY saveWOrigin 
2745 4D8D              saveWOrigin                             ;       
2746 4D8D              ;
2747 4D8D A0 E8 00              ldy   #y_origin                Save current, unzoomed, origin.
2748 4D90 B7 44                 lda   [<w_wind],y
2749 4D92 A0 02 01              ldy   #woldYOrg
2750 4D95 97 44                 sta   [<w_wind],y
2751 4D97              ;
2752 4D97 A0 EA 00              ldy   #x_origin
2753 4D9A B7 44                 lda   [<w_wind],y
2754 4D9C A0 04 01              ldy   #woldXOrg
2755 4D9F 97 44                 sta   [<w_wind],y
2756 4DA1 60                    rts   
2757 4DA2              ;
2758 4DA2              ;
2759 4DA2              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2760 4DA2              ;          Save window size/position to its wfull field.
2761 4DA2              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
2762 4DA2              ;
2763 4DA2              ;   IN:    <w_wind = pointer to window.
2764 4DA2              ;
2765 4DA2              ;  OUT:    <w_rect = window's wfull field.
2766 4DA2              ;          <wfull = window's current size.
2767 4DA2              ;
2768 4DA2                       ENTRY saveWRect 
2769 4DA2              saveWRect                               ;       
2770 4DA2              ;
2771 4DA2 A0 C2 00              ldy   #wcontRgn
2772 4DA5 20 60 53              jsr   getRgnBounds             <w_wrect = content bounds.
2773 4DA8              ;
2774 4DA8 A0 E2 00              ldy   #wfull+x2                last position = w_wrect (saved position).
2775 4DAB A2 06 00              ldx   #x2
2776 4DAE B7 44        lop2     lda   [<w_wind],y              Put current wFull into 'w_rect'.
2777 4DB0 95 0D                 sta   <w_rect,x
2778 4DB2 B5 05                 lda   <w_wrect,x               Replace wFull with current content size.
2779 4DB4 97 44                 sta   [<w_wind],y
2780 4DB6 88                    dey   
2781 4DB7 88                    dey   
2782 4DB8 CA                    dex   
2783 4DB9 CA                    dex   
2784 4DBA 10 F2                 bpl   lop2
2785 4DBC              ;
2786 4DBC 60                    rts   
2787 4DBD              ;
2788 4DBD                       ENDP 
2789 4DBD              ;
2790 4DBD              ;
2791 4DBD              ;================================================
2792 4DBD              ;          Set up window for drawing.
2793 4DBD              ;================================================
2794 4DBD              ;
2795 4DBD              ;   IN:    w_wind = window pointer.
2796 4DBD              ;
2797 4DBD              ;  OUT:    Nothing.
2798 4DBD              ;
2799 4DBD              hStartDrawing PROC 
2800 4DBD
2801 4DBD A6 46                 ldx   <w_wind+2                Pass pointer to window's port.
2802 4DBF A5 44                 lda   <w_wind
2803 4DC1 18                    clc   
2804 4DC2 69 04 00              adc   #wPort
2805 4DC5 90 01                 bcc   store1
2806 4DC7 E8                    inx   
2807 4DC8 DA           store1   phx   
2808 4DC9 48                    pha   
2809 4DCA A2 04 1B 22           _SetPort 
2810 4DD1              ;
2811 4DD1 A0 EA 00              ldy   #x_origin
2812 4DD4 B7 44                 lda   [<w_wind],y
2813 4DD6 AA                    tax   
2814 4DD7 88                    dey   
2815 4DD8 88                    dey   
2816 4DD9 B7 44                 lda   [<w_wind],y
2817 4DDB 20 72 22              jsr   setTheOrigin
2818 4DDE 18                    clc                            No error flag.
2819 4DDF 60                    rts   
2820 4DE0                       ENDP 
2821 4DE0              ;
2822 4DE0              ;
2823 4DE0              ;==============================================
2824 4DE0              ;          Called with new position.
2825 4DE0              ;==============================================
2826 4DE0              ;
2827 4DE0              ;   IN:    <w_wind = pointer to window.
2828 4DE0              ;          a = new y position.
2829 4DE0              ;          x = new x position.
2830 4DE0              ;
2831 4DE0              ;  OUT:    a = new y position.
2832 4DE0              ;          x = new x position.
2833 4DE0              ;
2834 4DE0              hStartMove PROC 
2835 4DE0
2836 4DE0 48                    pha                            Save new y.
2837 4DE1 DA                    phx                            Save new x.
2838 4DE2              ;
2839 4DE2 20 E8 4D              jsr   ckZoom                   Save position if zoomed.
2840 4DE5              ;
2841 4DE5 FA                    plx                            Return new x.
2842 4DE6 68                    pla                            Return new y.
2843 4DE7 60                    rts   
2844 4DE8                       ENDP 
2845 4DE8              ;
2846 4DE8              ;
2847 4DE8              ;==================================================
2848 4DE8              ;          If window is Zoomed, unzoom it.
2849 4DE8              ;==================================================
2850 4DE8              ;
2851 4DE8              ;   IN:    w_wind = pointer to window.
2852 4DE8              ;
2853 4DE8              ;  OUT:    If window is currently zoomed:
2854 4DE8              ;                Window's zoomed flag is cleared.
2855 4DE8              ;                Save current position as next zoomed position.
2856 4DE8              ;                Save current origin as next zoomed origin.
2857 4DE8              ;
2858 4DE8              ckZoom   PROC 
2859 4DE8
2860 4DE8 A0 D2 00              ldy   #wframe                  Is the window currently zoomed?
2861 4DEB B7 44                 lda   [<w_wind],y
2862 4DED 29 02 00              and   #F_ZOOMED
2863 4DF0 F0 0D                 beq   exit                     If not, exit.
2864 4DF2              ;
2865 4DF2              ;
2866 4DF2              ; --- Mark the window as not zoomed ----------------------------------------
2867 4DF2              ;
2868 4DF2 B7 44                 lda   [<w_wind],y              Clear zoomed flag.
2869 4DF4 49 02 00              eor   #F_ZOOMED
2870 4DF7 97 44                 sta   [<w_wind],y
2871 4DF9              ;
2872 4DF9              ;
2873 4DF9              ; --- Save the window's current size, position, and origin (zoomed size) ----
2874 4DF9              ;
2875 4DF9 20 A2 4D              jsr   saveWRect                wfull = current content size / position.
2876 4DFC 20 8D 4D              jsr   saveWOrigin              woldYOrg, woldXOrg = y_origin, x_origin.
2877 4DFF              ;
2878 4DFF 60           exit     rts   
2879 4E00                       ENDP 
2880 4E00              ;
2881 4E00              ;
2882 4E00              ;=======================================================
2883 4E00              ;          Swap 'y_origin' and 'x_origin'
2884 4E00              ;          with 'woldYOrg' and 'woldXOrg'.
2885 4E00              ;=======================================================
2886 4E00              ;
2887 4E00              ;   IN:    w_wind = pointer to window.
2888 4E00              ;
2889 4E00              swap_origin PROC 
2890 4E00
2891 4E00 A0 E8 00              ldy   #y_origin
2892 4E03 A2 02 01              ldx   #woldYOrg
2893 4E06 20 0D 4E              jsr   swap_word                Swap 'y_origin' and 'woldYOrg'.
2894 4E09              ;
2895 4E09 C8                    iny   
2896 4E0A C8                    iny   
2897 4E0B E8                    inx   
2898 4E0C E8                    inx   
2899 4E0D              ;
2900 4E0D              ;
2901 4E0D              ; = = = = = = = = = = = = = = = = = = = = = = = =
2902 4E0D              ;          Swap 2 words in the window .
2903 4E0D              ; = = = = = = = = = = = = = = = = = = = = = = = =
2904 4E0D              ;
2905 4E0D                       ENTRY swap_word 
2906 4E0D              swap_word                               ;       
2907 4E0D              ;
2908 4E0D              ;   IN:    y = offset to one word to swap.
2909 4E0D              ;          x = offset to the other word to swap.
2910 4E0D              ;          w_wind = pointer to window.
2911 4E0D              ;
2912 4E0D              ;  OUT:    y = same as in.
2913 4E0D              ;          x = same as in.
2914 4E0D              ;
2915 4E0D DA                    phx                            Save offset to param2.
2916 4E0E 5A                    phy                            Save offset to param1.
2917 4E0F              ;
2918 4E0F B7 44                 lda   [<w_wind],y              Get param1,
2919 4E11 48                    pha                            and save it.
2920 4E12 9B                    txy                            Get offset to param2.
2921 4E13 B7 44                 lda   [<w_wind],y              Get param2,
2922 4E15 AA                    tax                            and save in X.
2923 4E16 68                    pla                            Retrieve param1,
2924 4E17 97 44                 sta   [<w_wind],y              and store it where param2 was.
2925 4E19 7A                    ply                            Retrieve offset to param1.
2926 4E1A 8A                    txa                            Retrieve param2,
2927 4E1B 97 44                 sta   [<w_wind],y              and store it where param1 was.
2928 4E1D FA                    plx                            Retrieve offset to param2.
2929 4E1E 60                    rts   
2930 4E1F                       ENDP 
2931 4E1F              ;
2932 4E1F              ;
2933 4E1F              ;=====================================================
2934 4E1F              ;          Adjust origin if new size to
2935 4E1F              ;          larger than data area.
2936 4E1F              ;=====================================================
2937 4E1F              ;
2938 4E1F              ;   IN:    w_param = pointer to new height, width.
2939 4E1F              ;
2940 4E1F              ;  OUT:    y_origin reset if needed.
2941 4E1F              ;          x_origin reset if needed.
2942 4E1F              ;
2943 4E1F              hNewSize PROC 
2944 4E1F
2945 4E1F 85 15                 sta   <w_work                  Save pointer to new height / width.
2946 4E21 86 17                 stx   <w_work+2
2947 4E23              ;
2948 4E23 A0 02 00              ldy   #2                       Pass new height / width.
2949 4E26 B7 15                 lda   [<w_work],y
2950 4E28 AA                    tax                            Pass new width in X.
2951 4E29 A7 15                 lda   [<w_work]                Pass new height in A.
2952 4E2B              ;
2953 4E2B A0 F0 00              ldy   #wMaxHeight              New height cannot be greater than max.
2954 4E2E D7 44                 cmp   [<w_wind],y
2955 4E30 90 02                 bcc   ok1
2956 4E32 B7 44                 lda   [<w_wind],y              Use max height.
2957 4E34 48           ok1      pha                            Save new height.
2958 4E35              ;
2959 4E35 A0 F2 00              ldy   #wMaxWidth
2960 4E38 8A                    txa   
2961 4E39 D7 44                 cmp   [<w_wind],y
2962 4E3B 90 02                 bcc   ok2
2963 4E3D B7 44                 lda   [<w_wind],y
2964 4E3F              ;
2965 4E3F A0 02 00     ok2      ldy   #2                       Store new width.
2966 4E42 97 15                 sta   [<w_work],y
2967 4E44 AA                    tax                            Pass width in x.
2968 4E45              ;
2969 4E45 68                    pla                            Get new height.
2970 4E46 87 15                 sta   [<w_work]                Store new height.
2971 4E48              ;
2972 4E48              ;
2973 4E48              ; = = = = = = = = = = = = = = = = = = = = = = = = = =
2974 4E48              ;          Adjust origin if new size to
2975 4E48              ;          larger than data area.
2976 4E48              ;100= = = = = = = = = = = = = = = = = = = = = = = = =
2977 4E48              ;
2978 4E48              ;   IN:    a = new content height.
2979 4E48              ;          x = new content width.
2980 4E48              ;
2981 4E48              ;  OUT:    a = FALSE if origin reset, TRUE if not moved.
2982 4E48              ;          y_origin reset if needed.
2983 4E48              ;          x_origin reset if needed.
2984 4E48              ;
2985 4E48                       ENTRY ck_origin 
2986 4E48              ck_origin                               ;       
2987 4E48              ;
2988 4E48              newHeight equ   w_work
2989 4E48              newWidth equ   newHeight+2
2990 4E48              w_uncovered equ   newWidth+2
2991 4E48              ;
2992 4E48              ;
2993 4E48 85 15                 sta   <newHeight               Save new content height.
2994 4E4A 86 17                 stx   <newWidth                Save new content width.
2995 4E4C              ;
2996 4E4C 64 19                 stz   <w_uncovered             Default to draw only what's uncovered.
2997 4E4E E6 19                 inc   <w_uncovered
2998 4E50              ;
2999 4E50              ;
3000 4E50              ; --- Does window want its origin moved? --------------------------------
3001 4E50              ;
3002 4E50 A0 D2 00              ldy   #wframe
3003 4E53 B7 44                 lda   [<w_wind],y
3004 4E55 29 00 02              and   #F_FLEX
3005 4E58 F0 29                 beq   fixOrigin
3006 4E5A              ;
3007 4E5A              ;
3008 4E5A              ; ------ If not, the window's data size must be set -----------------
3009 4E5A              ;
3010 4E5A A0 E8 00              ldy   #y_origin
3011 4E5D B7 44                 lda   [<w_wind],y              y_origin plus,
3012 4E5F 18                    clc   
3013 4E60 65 15                 adc   <newHeight               content height,
3014 4E62 A0 EC 00              ldy   #data_h                  equals total data height exposed.
3015 4E65 D7 44                 cmp   [<w_wind],y              Is the new height greater than the old?
3016 4E67 90 02                 bcc   skip100
3017 4E69 97 44                 sta   [<w_wind],y              If yes, set the height to the greater.
3018 4E6B              ;
3019 4E6B A0 EA 00     skip100  ldy   #x_origin
3020 4E6E B7 44                 lda   [<w_wind],y              x_origin plus,
3021 4E70 18                    clc   
3022 4E71 65 17                 adc   <newWidth                content width,
3023 4E73 A0 DA 00              ldy   #worgn_mask
3024 4E76 37 44                 and   [<w_wind],y
3025 4E78 A0 EE 00              ldy   #data_w                  equals width of data exposed.
3026 4E7B D7 44                 cmp   [<w_wind],y              Is the new width greater than the old?
3027 4E7D 90 52                 bcc   exit100
3028 4E7F 97 44                 sta   [<w_wind],y              If yes, set the width to the greater.
3029 4E81 80 4E                 bra   exit100
3030 4E83              ;
3031 4E83              ;
3032 4E83              ; --- Check Y origin -----------------------------------
3033 4E83              ;
3034 4E83 A0 E8 00     fixOrigin ldy   #y_origin
3035 4E86 B7 44                 lda   [<w_wind],y              y_origin plus,
3036 4E88 18                    clc   
3037 4E89 65 15                 adc   <newHeight               content height,
3038 4E8B A0 EC 00              ldy   #data_h                  equals total data height exposed.
3039 4E8E D7 44                 cmp   [<w_wind],y              Is it greater than the data height?
3040 4E90 90 13                 bcc   ok100
3041 4E92 F0 11                 beq   ok100
3042 4E94              ;
3043 4E94              ;
3044 4E94              ; ------ Reset Y origin -------------------------------
3045 4E94              ;
3046 4E94 B7 44                 lda   [<w_wind],y
3047 4E96 38                    sec   
3048 4E97 E5 15                 sbc   <newHeight
3049 4E99 B0 03                 bcs   ok101
3050 4E9B A9 00 00              lda   #0                       Minimum.
3051 4E9E A0 E8 00     ok101    ldy   #y_origin
3052 4EA1 97 44                 sta   [<w_wind],y
3053 4EA3              ;
3054 4EA3 64 19                 stz   <w_uncovered             Set flag to redraw entire content region.
3055 4EA5              ;
3056 4EA5              ;
3057 4EA5              ; --- Check X origin -----------------------------------
3058 4EA5              ;
3059 4EA5 A0 EA 00     ok100    ldy   #x_origin
3060 4EA8 B7 44                 lda   [<w_wind],y              x_origin plus,
3061 4EAA 18                    clc   
3062 4EAB 65 17                 adc   <newWidth                content width,
3063 4EAD A0 DA 00              ldy   #worgn_mask
3064 4EB0 37 44                 and   [<w_wind],y
3065 4EB2 A0 EE 00              ldy   #data_w                  equals width of data exposed.
3066 4EB5 D7 44                 cmp   [<w_wind],y              Is it greater than the data width?
3067 4EB7 90 18                 bcc   exit100
3068 4EB9 F0 16                 beq   exit100
3069 4EBB              ;
3070 4EBB              ;
3071 4EBB              ; ------ Reset x_orgin ----------------------------------
3072 4EBB              ;
3073 4EBB B7 44                 lda   [<w_wind],y
3074 4EBD 38                    sec   
3075 4EBE E5 17                 sbc   <newWidth
3076 4EC0 B0 03                 bcs   ok102
3077 4EC2 A9 00 00              lda   #0                       Minimum.
3078 4EC5              ;
3079 4EC5 A0 DA 00     ok102    ldy   #worgn_mask              Force X origin to desired boundary.
3080 4EC8 37 44                 and   [<w_wind],y
3081 4ECA              ;
3082 4ECA A0 EA 00              ldy   #x_origin
3083 4ECD 97 44                 sta   [<w_wind],y
3084 4ECF              ;
3085 4ECF 64 19                 stz   <w_uncovered             Set flag to redraw entire content region.
3086 4ED1              ;
3087 4ED1 A5 19        exit100  lda   <w_uncovered             Return content draw flag.
3088 4ED3 18                    clc                            No error flag.
3089 4ED4 60                    rts   
3090 4ED5                       ENDP 
3091 4ED5              ;
3092 4ED5              ;
3093 4ED5              ;============================================
3094 4ED5              ;          Handle TaskMaster task.
3095 4ED5              ;============================================
3096 4ED5              ;
3097 4ED5              ;   IN:    x/a = pointer to task record.
3098 4ED5              ;          <w_param = pointer to:
3099 4ED5              ;                             WORD - request code.
3100 4ED5              ;                             WORD - defProc ID.
3101 4ED5              ;                             LONG - task record pointer.
3102 4ED5              ;                             WORD - result from FindWindow.
3103 4ED5              ;          <w_wind = pointer to window's record.
3104 4ED5              ;          <taskRec+taskData = pointer to window's port.
3105 4ED5              ;
3106 4ED5              ;  OUT:    a = zero if task handled, else result from FindWindow.
3107 4ED5              ;          x = task action.
3108 4ED5              ;
3109 4ED5              hTask    PROC 
3110 4ED5              ;
3111 4ED5                                                      ;using equates
3112 4ED5              ;
3113 4ED5              taskRec  equ   w_work
3114 4ED5              foundCtl equ   taskRec+4
3115 4ED5              ;
3116 4ED5              ;
3117 4ED5 85 15                 sta   <taskRec
3118 4ED7 86 17                 stx   <taskRec+2
3119 4ED9              ;
3120 4ED9              ;
3121 4ED9              ; --- Dispatch to the specific task handler --------------------------
3122 4ED9              ;
3123 4ED9 A0 08 00              ldy   #newParam+4              Get result from FindWindow.
3124 4EDC B7 40                 lda   [<w_param],y
3125 4EDE 38                    sec   
3126 4EDF E9 13 00              sbc   #$13
3127 4EE2 90 05                 bcc   cant
3128 4EE4 C9 09 00              cmp   #9
3129 4EE7 90 03                 bcc   ok
3130 4EE9 A9 06 00     cant     lda   #6                       Force call to cantHandle.
3131 4EEC 0A           ok       asl   a
3132 4EED AA                    tax   
3133 4EEE 7C F1 4E              jmp   (taskDoers,x)
3134 4EF1              ;
3135 4EF1 75 4F        taskDoers DC W:content                  $13  0
3136 4EF3 29 4F                 DC W:drag                      $14  1
3137 4EF5 DF 4F                 DC W:grow                      $15  2
3138 4EF7 95 4F                 DC W:goAway                    $16  3
3139 4EF9 B7 4F                 DC W:zoom                      $17  4
3140 4EFB 03 4F                 DC W:infoBar                   $18  5
3141 4EFD 20 4F                 DC W:cantHandle                $19  6
3142 4EFF 20 4F                 DC W:cantHandle                $1A  7
3143 4F01 12 50                 DC W:frame                     $1B  8
3144 4F03              ;
3145 4F03              ;
3146 4F03              ; = = = = = = = = = = = = = = = = = = = =
3147 4F03              ;          wInInfo
3148 4F03              ;100= = = = = = = = = = = = = = = = = = =
3149 4F03              ;
3150 4F03 A0 14 00     infoBar  ldy   #taskMask                Check if window should be made top.
3151 4F06 B7 15                 lda   [<taskRec],y
3152 4F08 29 00 80              and   #TM_INFO
3153 4F0B F0 07                 beq   ok100
3154 4F0D A2 00 00              ldx   #0                       No action taken.
3155 4F10 A9 18 00              lda   #wInInfo                 Return in info flag.
3156 4F13 60                    rts   
3157 4F14              ;
3158 4F14 20 7D 50     ok100    jsr   check_top                Check if window is active,
3159 4F17 90 07                 bcc   cantHandle               if the window has to be made active
3160 4F19              ;                                       it means the event is handled.
3161 4F19              ;
3162 4F19 A2 18 00              ldx   #wInInfo                 Return action taken.
3163 4F1C A9 00 00              lda   #0                       Task handled.
3164 4F1F 60                    rts   
3165 4F20              ;
3166 4F20              ;
3167 4F20              ; = = = = = = = = = = = = = = = = = = = =
3168 4F20              ;          TaskMaster can't handle
3169 4F20              ;          this task (must not be a Master).
3170 4F20              ;110= = = = = = = = = = = = = = = = = = =
3171 4F20              ;
3172 4F20 A0 08 00     cantHandle ldy   #newParam+4            Return the code passed to me, back.
3173 4F23 B7 40                 lda   [<w_param],y
3174 4F25 A2 00 00              ldx   #0                       No action.
3175 4F28 60                    rts   
3176 4F29              ;
3177 4F29              ;
3178 4F29              ; = = = = = = = = = = = = = = = = = = = =
3179 4F29              ;          Drag Window.
3180 4F29              ;120= = = = = = = = = = = = = = = = = = =
3181 4F29              ;
3182 4F29              ;
3183 4F29              ; ------ Check if window should be brought to the top --------------
3184 4F29              ;
3185 4F29 A0 14 00     drag     ldy   #taskMask                Check if window should be made top.
3186 4F2C B7 15                 lda   [<taskRec],y
3187 4F2E 29 40 00              and   #TM_DRAGW
3188 4F31 D0 07                 bne   ok120
3189 4F33 A2 00 00              ldx   #0                       No action taken.
3190 4F36 A9 14 00              lda   #wInDrag                 Return in drag flag.
3191 4F39 60                    rts   
3192 4F3A              ;
3193 4F3A A0 D2 00     ok120    ldy   #wFrame                  Check if window can be moved.
3194 4F3D B7 44                 lda   [<w_wind],y
3195 4F3F 29 80 00              and   #F_MOVE
3196 4F42 F0 2A                 beq   exit120
3197 4F44              ;
3198 4F44 20 B7 50              jsr   startToGlobal            Convert starting point to global.
3199 4F47              ;
3200 4F47 A2 00 00              ldx   #0                       Default grid, don't bring window to top.
3201 4F4A              ;
3202 4F4A A0 0E 00              ldy   #modif                   Read modifier keys state from event.
3203 4F4D B7 15                 lda   [<taskRec],y
3204 4F4F 29 00 01              and   #K_COMMAND               Is the command key down?
3205 4F52 D0 03                 bne   skip120
3206 4F54              ;
3207 4F54 A2 00 80              ldx   #$8000                   Default grid, bring window to front.
3208 4F57              ;
3209 4F57              ;
3210 4F57              ; ------ Now drag the window in its current plane ---------------------
3211 4F57              ;
3212 4F57 DA           skip120  phx                            Pass drag flag.
3213 4F58 20 A9 50              jsr   pushStartPos             Pass starting point.
3214 4F5B F4 08 00              pea   8                        Grace buffer.
3215 4F5E F4 00 00              pea   0                        Use default bounds RECT.
3216 4F61 F4 00 00              pea   0
3217 4F64 20 A4 50              jsr   pushWgraphPort           Pass pointer to window's graphPort.
3218 4F67 A2 0E 1A 22           _DragWindow 
3219 4F6E              ;
3220 4F6E A2 14 00     exit120  ldx   #wInDrag                 Window was dragged action message.
3221 4F71 A9 00 00              lda   #0                       Task handled.
3222 4F74 60                    rts   
3223 4F75              ;
3224 4F75              ;
3225 4F75              ; = = = = = = = = = = = = = = = = = = = =
3226 4F75              ;          wInContent
3227 4F75              ;130= = = = = = = = = = = = = = = = = = =
3228 4F75              ;
3229 4F75 A0 14 00     content  ldy   #taskMask                Check if window should be made top.
3230 4F78 B7 15                 lda   [<taskRec],y
3231 4F7A 29 80 00              and   #TM_CONTENT
3232 4F7D F0 0F                 beq   exit130
3233 4F7F              ;
3234 4F7F 20 7D 50              jsr   check_top
3235 4F82 90 9C                 bcc   cantHandle               Did the window have to be selected?
3236 4F84              ;                                       If not, return wInContent message.
3237 4F84              ;
3238 4F84 A0 D2 00              ldy   #wframe                  Does the window wish to reuse the button?
3239 4F87 B7 44                 lda   [<w_wind],y
3240 4F89 29 40 00              and   #F_QCONTENT
3241 4F8C D0 92                 bne   cantHandle               Reuse the button down.
3242 4F8E              ;
3243 4F8E A2 13 00     exit130  ldx   #wInContent              Button in content brought window to top.
3244 4F91 A9 00 00              lda   #0                       Task handled.
3245 4F94 60                    rts   
3246 4F95              ;
3247 4F95              ;
3248 4F95              ; = = = = = = = = = = = = = = = = = = = =
3249 4F95              ;          wInGoAway
3250 4F95              ;140= = = = = = = = = = = = = = = = = = =
3251 4F95              ;
3252 4F95 20 B7 50     goAway   jsr   startToGlobal            Convert starting point to global.
3253 4F98              ;
3254 4F98 48                    pha                            Return space.
3255 4F99 20 A9 50              jsr   pushStartPos             Pass starting point.
3256 4F9C 20 A4 50              jsr   pushWgraphPort           Pass pointer to window's graphPort.
3257 4F9F A2 0E 18 22           _TrackGoAway 
3258 4FA6 68                    pla                            Was the user inside the close box?
3259 4FA7 D0 07                 bne   exit140                  -yes.
3260 4FA9              ;
3261 4FA9 A2 16 00              ldx   #wInGoAway               User clicked in close box, but it was
3262 4FAC A9 00 00              lda   #0                       Task handled.
3263 4FAF 60                    rts   
3264 4FB0              ;
3265 4FB0 A2 00 00     exit140  ldx   #0                       No action.
3266 4FB3 A9 16 00              lda   #wInGoAway               Close window.
3267 4FB6 60                    rts   
3268 4FB7              ;
3269 4FB7              ;
3270 4FB7              ; = = = = = = = = = = = = = = = = = = = =
3271 4FB7              ;          wInZoom
3272 4FB7              ;150= = = = = = = = = = = = = = = = = = =
3273 4FB7              ;
3274 4FB7 20 B7 50     zoom     jsr   startToGlobal            Convert starting point to global.
3275 4FBA              ;
3276 4FBA 48                    pha                            Return space.
3277 4FBB 20 A9 50              jsr   pushStartPos             Pass starting point.
3278 4FBE 20 A4 50              jsr   pushWgraphPort           Pass pointer to window's graphPort.
3279 4FC1 A2 0E 26 22           _TrackZoom 
3280 4FC8 A2 1F 00              ldx   #wTrackZoom              Tell caller that the zoom box was tracked,
3281 4FCB 68                    pla                            but not selected, just in case.
3282 4FCC F0 0D                 beq   exitZoom                 Did the user select the zoom box?
3283 4FCE              ;
3284 4FCE              ;
3285 4FCE              ; ---------- Zoom window ------------------------------------------
3286 4FCE              ;
3287 4FCE 20 A4 50              jsr   pushWgraphPort           Save pointer to window's graphPort.
3288 4FD1 A2 0E 27 22           _ZoomWindow                    (Window pointer already on stack.)
3289 4FD8              ;
3290 4FD8 A2 17 00              ldx   #wInZoom                 Window was zoomed.
3291 4FDB A9 00 00     exitZoom lda   #0                       Task handled.
3292 4FDE 60                    rts   
3293 4FDF              ;
3294 4FDF              ;
3295 4FDF              ; = = = = = = = = = = = = = = = = = = = =
3296 4FDF              ;          wInGrow
3297 4FDF              ;160= = = = = = = = = = = = = = = = = = =
3298 4FDF              ;
3299 4FDF 20 7D 50     grow     jsr   check_top                Check if window is top most.
3300 4FE2 90 05                 bcc   ok160                    If not, made top, and done.
3301 4FE4              ;
3302 4FE4 A9 00 00              lda   #0                       Task handled.
3303 4FE7 AA                    tax                            No action.
3304 4FE8 60                    rts   
3305 4FE9              ;
3306 4FE9 20 B7 50     ok160    jsr   startToGlobal            Convert starting point to global.
3307 4FEC              ;
3308 4FEC 48                    pha                            Space for result.
3309 4FED 48                    pha   
3310 4FEE F4 64 00              pea   100                      Minimum width allowed.
3311 4FF1 F4 28 00              pea   40                       Minimum height allowed.
3312 4FF4 20 A9 50              jsr   pushStartPos             Pass starting point.
3313 4FF7 20 A4 50              jsr   pushWgraphPort           Pass pointer to window's graphPort.
3314 4FFA A2 0E 1B 22           _GrowWindow 
3315 5001              ;                                       Pass new height/width from GrowWindow.
3316 5001 20 A4 50              jsr   pushWgraphPort           Save pointer to window's graphPort.
3317 5004 A2 0E 1C 22           _SizeWindow                    (Window pointer already on stack.)
3318 500B              ;
3319 500B A2 15 00              ldx   #wInGrow                 Window resized.
3320 500E A9 00 00              lda   #0                       Task handled.
3321 5011 60                    rts   
3322 5012              ;
3323 5012              ;
3324 5012              ; = = = = = = = = = = = = = = = = = = = =
3325 5012              ;          wInFrame
3326 5012              ;170= = = = = = = = = = = = = = = = = = =
3327 5012              ;
3328 5012 20 7D 50     frame    jsr   check_top                Check if window is top most.
3329 5015 B0 3F                 bcs   exit171                  If not, made top and task handled.
3330 5017              ;
3331 5017              ;
3332 5017              ; --- Check for hit on frame control -------------------------
3333 5017              ;
3334 5017 20 C5 50              jsr   startFrameDraw
3335 501A              ;
3336 501A 20 B7 50              jsr   startToGlobal            Convert starting point to global.
3337 501D              ;
3338 501D 48                    pha                            Space for result.
3339 501E A9 19 00              lda   #foundCtl                Pass place to store handle of control.
3340 5021 20 64 8F              jsr   pushDpage
3341 5024 20 A9 50              jsr   pushStartPos             Pass starting point.
3342 5027 48                    pha                            Pass pointer to window.
3343 5028 48                    pha   
3344 5029 A2 04 1C 22           _GetPort                       Current port is port to check.
3345 5030 A2 10 13 22           _FindControl 
3346 5037 68                    pla                            Control found?
3347 5038 F0 19                 beq   exit170
3348 503A              ;
3349 503A 48                    pha                            Space for result.
3350 503B 48                    pha   
3351 503C D4 1B                 pei   <foundCtl+2              Pass handle of found control.
3352 503E D4 19                 pei   <foundCtl
3353 5040 A2 10 23 22           _GetCtlRefCon 
3354 5047 68                    pla   
3355 5048 68                    pla                            Get control's ID.
3356 5049 C9 06 00              cmp   #HScrollID               Is the control a scroll bar?
3357 504C F0 0F                 beq   ok170
3358 504E C9 04 00              cmp   #VScrollID
3359 5051 F0 0A                 beq   ok170
3360 5053              ;
3361 5053 20 D1 50     exit170  jsr   endFrameDraw
3362 5056              ;
3363 5056 A2 20 00     exit171  ldx   #wHitFrame               Tell caller user clicked in window frame.
3364 5059 A9 00 00              lda   #0                       Task handled.
3365 505C 60                    rts   
3366 505D              ;
3367 505D              ;
3368 505D              ; --- Track the control --------------------------------------
3369 505D              ;
3370 505D 48           ok170    pha                            Space for result.
3371 505E 20 A9 50              jsr   pushStartPos             Pass starting point.
3372 5061 F4 FD 00              pea   TaskScroll>>16           Pass action procedure address.
3373 5064 F4 D9 50              pea   TaskScroll               w_wind = window pointer for TrackScroll.
3374 5067 D4 1B                 pei   <foundCtl+2              Pass handle of control to track.
3375 5069 D4 19                 pei   <foundCtl
3376 506B A2 10 15 22           _TrackControl 
3377 5072 68                    pla                            Result not used.
3378 5073              ;
3379 5073 20 D1 50              jsr   endFrameDraw
3380 5076              ;
3381 5076 A2 1B 00              ldx   #wInFrame                Scroll bar may have changed.
3382 5079 A9 00 00              lda   #0                       Task handled.
3383 507C 60                    rts   
3384 507D              ;
3385 507D              ;
3386 507D              ; = = = = = = = = = = = = = = = = = = = = = =
3387 507D              ;          Check if window is top.
3388 507D              ;190= = = = = = = = = = = = = = = = = = = = =
3389 507D              ;
3390 507D              ;   IN:    w_wind = pointer to window's record.
3391 507D              ;
3392 507D              ;  OUT:    Carry clear of window already on top.
3393 507D              ;          Carry set if window made top.
3394 507D              ;
3395 507D              check_top                               ; 
3396 507D              ;
3397 507D 48                    pha                            Space for result.
3398 507E 48                    pha   
3399 507F A2 0E 15 22           _FrontWindow 
3400 5086 68                    pla                            Get pointer to top graphPort.
3401 5087 FA                    plx   
3402 5088              ;
3403 5088 A0 10 00              ldy   #taskData                Compare top to this window.
3404 508B D7 15                 cmp   [<taskRec],y
3405 508D D0 09                 bne   totop
3406 508F 8A                    txa   
3407 5090 C8                    iny   
3408 5091 C8                    iny   
3409 5092 D7 15                 cmp   [<taskRec],y
3410 5094 D0 02                 bne   totop
3411 5096 18                    clc                            Window is on top flag.
3412 5097 60                    rts   
3413 5098              ;
3414 5098 20 A4 50     totop    jsr   pushWgraphPort           Pass pointer to window's graphPort.
3415 509B A2 0E 11 22           _SelectWindow                  Bring the window to the top.
3416 50A2              ;
3417 50A2 38                    sec                            Window made top window.
3418 50A3 60                    rts   
3419 50A4              ;
3420 50A4              ;
3421 50A4              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
3422 50A4              ;          Push long value from task record.
3423 50A4              ;200= = = = = = = = = = = = = = = = = = = = = = = = = = =
3424 50A4              ;
3425 50A4              ;   IN:    <taskRec = pointer to task record.
3426 50A4              ;
3427 50A4              ;  OUT:    Pointer to window graphPort on stack.
3428 50A4              ;
3429 50A4              pushWgraphPort                          ; 
3430 50A4              ;
3431 50A4 A0 12 00              ldy   #taskData+2
3432 50A7 80 03                 bra   pushTaskField
3433 50A9              ;
3434 50A9              pushStartPos                            ; 
3435 50A9              ;
3436 50A9 A0 0C 00              ldy   #where+x1
3437 50AC              ;
3438 50AC              pushTaskField                           ; 
3439 50AC              ;
3440 50AC FA                    plx   
3441 50AD              ;
3442 50AD B7 15                 lda   [<taskRec],y
3443 50AF 48                    pha   
3444 50B0 88                    dey   
3445 50B1 88                    dey   
3446 50B2 B7 15                 lda   [<taskRec],y
3447 50B4 48                    pha   
3448 50B5              ;
3449 50B5 DA                    phx   
3450 50B6 60                    rts   
3451 50B7              ;
3452 50B7              ;
3453 50B7              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = =
3454 50B7              ;          Convert starting point to global.
3455 50B7              ;210= = = = = = = = = = = = = = = = = = = = = = = = = = =
3456 50B7              ;
3457 50B7              startToGlobal                           ; 
3458 50B7              ;
3459 50B7 A9 1F 00              lda   #taskRec+where           Pass pointer to starting point.
3460 50BA 20 64 8F              jsr   pushDpage
3461 50BD A2 04 84 22           _LocalToGlobal 
3462 50C4 60                    rts   
3463 50C5              ;
3464 50C5                       ENDP 
3465 50C5              ;
3466 50C5              ;
3467 50C5              ;========================================
3468 50C5              ;          Setup to draw frame.
3469 50C5              ;========================================
3470 50C5              ;
3471 50C5              ;   IN:    <w_wind = pointer to window record of window to draw.
3472 50C5              ;
3473 50C5              startFrameDraw PROC 
3474 50C5
3475 50C5 D4 46                 pei   <w_wind+2                Pass window record pointer.
3476 50C7 D4 44                 pei   <w_wind
3477 50C9 A2 0E 5A 22           _StartFrameDrawing 
3478 50D0              ;
3479 50D0 60                    rts   
3480 50D1                       ENDP 
3481 50D1              ;
3482 50D1              ;
3483 50D1              ;===========================================
3484 50D1              ;          Undo setup to draw frame.
3485 50D1              ;===========================================
3486 50D1              ;
3487 50D1              ;   IN:    startFrameDraw must have been called.
3488 50D1              ;
3489 50D1              endFrameDraw PROC 
3490 50D1              ;
3491 50D1 A2 0E 5B 22           _EndFrameDrawing 
3492 50D8 60                    rts   
3493 50D9                       ENDP 
3494 50D9              ;
3495 50D9              ;
3496 50D9              ;///////////////////////////////////////////////////
3497 50D9              ;          Action routine for scrolling
3498 50D9              ;          from scroll bars in window frame.
3499 50D9              ;///////////////////////////////////////////////////
3500 50D9              ;
3501 50D9              ;   IN:    PUSH:WORD - part code.
3502 50D9              ;          PUSH:LONG - handle of control.
3503 50D9              ;
3504 50D9              ;          Direct page is same as defProc's.
3505 50D9              ;                <w_wind = pointer to window this scroll bar controls.
3506 50D9              ;
3507 50D9              TaskScroll PROC 
3508 50D9              ;
3509 50D9                                                      ;using equates
3510 50D9              ;
3511 50D9              return   equ   1
3512 50D9              control  equ   return+3
3513 50D9              part     equ   control+4
3514 50D9              ;
3515 50D9              ctlPtr   equ   w_work
3516 50D9              sAmount  equ   ctlPtr+4
3517 50D9              pAmount  equ   sAmount+2
3518 50D9              horDelta equ   pAmount+2
3519 50D9              verDelta equ   horDelta+2
3520 50D9              ;
3521 50D9              ;
3522 50D9 A3 06                 lda   control+2,s
3523 50DB AA                    tax   
3524 50DC A3 04                 lda   control,s
3525 50DE 20 00 52              jsr   getcontrol2              Get control pointer.
3526 50E1              ;
3527 50E1 A2 F4 00              ldx   #vscroll
3528 50E4 A0 10 00              ldy   #CtlFlag
3529 50E7 B7 15                 lda   [<ctlPtr],y
3530 50E9 29 10 00              and   #DIR_SCROLL              Vertical or horizontal?
3531 50EC F0 03                 beq   ok1
3532 50EE A2 F6 00              ldx   #hscroll
3533 50F1 9B           ok1      txy   
3534 50F2 B7 44                 lda   [<w_wind],y
3535 50F4 85 19                 sta   <sAmount                 Scroll amount.
3536 50F6 C8                    iny   
3537 50F7 C8                    iny   
3538 50F8 C8                    iny   
3539 50F9 C8                    iny   
3540 50FA B7 44                 lda   [<w_wind],y
3541 50FC D0 1C                 bne   store1                   Use default page value?
3542 50FE              ;
3543 50FE A2 0C 00              ldx   #CtlRect+y2
3544 5101 A0 10 00              ldy   #CtlFlag
3545 5104 B7 15                 lda   [<ctlPtr],y
3546 5106 29 10 00              and   #DIR_SCROLL              Vertical or horizontal?
3547 5109 F0 02                 beq   ok4
3548 510B E8                    inx   
3549 510C E8                    inx   
3550 510D 9B           ok4      txy   
3551 510E B7 15                 lda   [<ctlPtr],y              y2 or x2.
3552 5110 88                    dey   
3553 5111 88                    dey   
3554 5112 88                    dey   
3555 5113 88                    dey   
3556 5114 38                    sec   
3557 5115 F7 15                 sbc   [<ctlPtr],y              y1 or x1.
3558 5117 E9 0A 00              sbc   #10
3559 511A              ;          
3560 511A 85 1B        store1   sta   <pAmount                 Page amount.
3561 511C              ;
3562 511C              ;
3563 511C A3 08                 lda   part,s
3564 511E 29 7F 00              and   #$7F
3565 5121 D0 03                 bne   ok5
3566 5123 82 C9 00              brl   exit
3567 5126 0A           ok5      asl   a
3568 5127 AA                    tax   
3569 5128 A0 12 00              ldy   #CtlValue                Common need.
3570 512B 7C 2C 51              jmp   (part_act-2,x)
3571 512E              ;
3572 512E 3E 51        part_act DC W:act_thumb                 1
3573 5130 EF 51                 DC W:act_butt                  2 Just exit.
3574 5132 EF 51                 DC W:act_check                 3 Just exit.
3575 5134 EF 51                 DC W:act_radio                 4 Just exit.
3576 5136 54 51                 DC W:act_up                    5
3577 5138 5B 51                 DC W:act_down                  6
3578 513A 5F 51                 DC W:act_pup                   7
3579 513C 6C 51                 DC W:act_pdown                 8
3580 513E              ;
3581 513E              ;
3582 513E              ;----------------------------------
3583 513E              ;          Track thumb.
3584 513E              ;----------------------------------
3585 513E              ;
3586 513E B7 15        act_thumb lda   [<ctlPtr],y             Get new value (was set by Control Manager),
3587 5140 AA                    tax                            (Save the actual new value.)
3588 5141 48                    pha                            and put on stack like everyone else.
3589 5142              ;
3590 5142 A0 20 00              ldy   #CtlrefCon               Now get last value,
3591 5145 B7 15                 lda   [<ctlPtr],y              and make current value,
3592 5147 A0 12 00              ldy   #ctlValue                so code can compute change (delta) in position for scroll.
3593 514A 97 15                 sta   [<ctlPtr],y
3594 514C A0 20 00              ldy   #ctlRefCon               Save actual new value.
3595 514F 8A                    txa   
3596 5150 97 15                 sta   [<ctlPtr],y
3597 5152 80 2E                 bra   new_value                Now go do scroll.
3598 5154              ;
3599 5154              ;
3600 5154              ;------------------------------------------
3601 5154              ;          Track up/left arrow.
3602 5154              ;------------------------------------------
3603 5154              ;
3604 5154 B7 15        act_up   lda   [<ctlPtr],y
3605 5156 38                    sec   
3606 5157 E5 19                 sbc   <sAmount
3607 5159 80 09                 bra   enter1
3608 515B              ;
3609 515B              ;
3610 515B              ;------------------------------------------
3611 515B              ;          Track down/right arrow.
3612 515B              ;------------------------------------------
3613 515B              ;
3614 515B A5 19        act_down lda   <sAmount
3615 515D 80 0F                 bra   add_value
3616 515F              ;
3617 515F              ;
3618 515F              ;------------------------------------------
3619 515F              ;          Track up/left page.
3620 515F              ;------------------------------------------
3621 515F              ;
3622 515F B7 15        act_pup  lda   [<ctlPtr],y
3623 5161 38                    sec   
3624 5162 E5 1B                 sbc   <pAmount
3625 5164 48           enter1   pha                            Pass new value to SetCtlValue.
3626 5165 B0 1B                 bcs   new_value
3627 5167 A9 00 00              lda   #0
3628 516A 80 14                 bra   reset
3629 516C              ;
3630 516C              ;
3631 516C              ;------------------------------------------
3632 516C              ;          Track down/right page.
3633 516C              ;------------------------------------------
3634 516C              ;
3635 516C A5 1B        act_pdown lda   <pAmount
3636 516E              ;
3637 516E              ;
3638 516E 18           add_value clc   
3639 516F 77 15                 adc   [<ctlPtr],y              Add to current value.
3640 5171 48                    pha                            Pass new value to SetCtlValue.
3641 5172              ;
3642 5172 A0 1E 00              ldy   #CtlData+2               Maximum value allowed is,
3643 5175 B7 15                 lda   [<ctlPtr],y              data size,
3644 5177 88                    dey   
3645 5178 88                    dey   
3646 5179 38                    sec   
3647 517A F7 15                 sbc   [<ctlPtr],y              less view size.
3648 517C C3 01                 cmp   1,s
3649 517E B0 02                 bcs   new_value                Is max greater than new value?
3650 5180              ;
3651 5180 83 01        reset    sta   1,s                      If not, set to max.
3652 5182              ;
3653 5182              ;
3654 5182              ; ------ Compute the RECT to scroll and switch to window's port --------
3655 5182              ;
3656 5182              new_value  
3657 5182 A0 10 00              ldy   #ctlFlag                 Is this the horizontal scroll bar.
3658 5185 B7 15                 lda   [<ctlPtr],y
3659 5187 29 10 00              and   #DIR_SCROLL
3660 518A F0 07                 beq   @skip1
3661 518C A0 DA 00              ldy   #worgn_mask              Mask position of horizontal scroll bar.
3662 518F 68                    pla   
3663 5190 37 44                 and   [<w_wind],y
3664 5192 48                    pha   
3665 5193              @skip1    
3666 5193              ;
3667 5193 A0 12 00              ldy   #CtlValue
3668 5196 B7 15                 lda   [<ctlPtr],y              Old value,
3669 5198 38                    sec   
3670 5199 E3 01                 sbc   1,s                      less new value
3671 519B AA                    tax                            is change.
3672 519C A0 10 00              ldy   #CtlFlag
3673 519F B7 15                 lda   [<ctlPtr],y
3674 51A1 A0 00 00              ldy   #0                       Y = zero cause it's the other delta and only one can change.
3675 51A4 29 10 00              and   #DIR_SCROLL              Vertical or horizontal?
3676 51A7 F0 03                 beq   ok3
3677 51A9 98                    tya   
3678 51AA 9B                    txy   
3679 51AB AA                    tax   
3680 51AC 84 1D        ok3      sty   <horDelta                Horizontal change.
3681 51AE 86 1F                 stx   <verDelta                Vertical change.
3682 51B0              ;
3683 51B0 A0 E8 00              ldy   #y_origin                Current y origin,
3684 51B3 B7 44                 lda   [<w_wind],y
3685 51B5 38                    sec   
3686 51B6 E5 1F                 sbc   <verDelta                less y delta,
3687 51B8 48                    pha                            equals new y origin.
3688 51B9              ;
3689 51B9 A0 EA 00              ldy   #x_origin                Current x origin,
3690 51BC B7 44                 lda   [<w_wind],y
3691 51BE 38                    sec   
3692 51BF E5 1D                 sbc   <horDelta                less x delta.
3693 51C1 10 03                 bpl   @ok
3694 51C3 A9 00 00              lda   #0                       New X can't be negative. Sometimes the x origin of the
3695 51C6              ;                                       window doesn't match the scroll bar value.
3696 51C6 AA           @ok      tax                            Pass new X origin.
3697 51C7 68                    pla                            Pass new Y origin.
3698 51C8 20 21 4A              jsr   new_origin
3699 51CB              ;
3700 51CB              ;
3701 51CB              ; --- Set scroll bar to new value ----------------------------
3702 51CB              ;
3703 51CB 20 FB 51              jsr   getcontrol               Dereference control's handle.
3704 51CE              ;
3705 51CE A0 20 00              ldy   #CtlRefCon               Save new position as old position.
3706 51D1 B7 15                 lda   [<ctlPtr],y              Save old in case of thumb.
3707 51D3 AA                    tax   
3708 51D4 A3 01                 lda   1,s
3709 51D6 97 15                 sta   [<ctlPtr],y
3710 51D8              ;
3711 51D8              ;
3712 51D8              ; ------ Special case when thumb dragged.
3713 51D8              ;
3714 51D8 A3 09                 lda   part+1,s                 If page or arrows then ready to set new position.
3715 51DA 10 06                 bpl   @ok1
3716 51DC              ;
3717 51DC 8A                    txa                            Actual value into A.
3718 51DD A0 12 00              ldy   #ctlValue
3719 51E0 97 15                 sta   [<ctlPtr],y              Set new value, position of thumb already correct.
3720 51E2              ;
3721 51E2              @ok1      
3722 51E2              ;                                       New value already on stack.
3723 51E2 A3 08                 lda   control+4,s              Pass handle of control.
3724 51E4 48                    pha   
3725 51E5 A3 08                 lda   control+4,s
3726 51E7 48                    pha   
3727 51E8 A2 10 19 22           _SetCtlValue 
3728 51EF              ;
3729 51EF              ;
3730 51EF              ;
3731 51EF              act_butt                                ; 
3732 51EF              act_check                               ; 
3733 51EF              act_radio                               ; 
3734 51EF              ;
3735 51EF A3 00        EXIT     lda   0,s
3736 51F1 83 06                 sta   6,s
3737 51F3 A3 02                 lda   2,s
3738 51F5 83 08                 sta   8,s
3739 51F7 68                    pla   
3740 51F8 68                    pla   
3741 51F9 68                    pla   
3742 51FA 6B                    rtl   
3743 51FB              ;
3744 51FB              ;
3745 51FB              ;
3746 51FB A3 0A        getcontrol lda   control+6,s
3747 51FD AA                    tax   
3748 51FE A3 08                 lda   control+4,s
3749 5200              ;
3750 5200              ;
3751 5200              ; = = = = = = = = = = = = = = = = = = = = = = = =
3752 5200              ;          Convert handle into pointer.
3753 5200              ; = = = = = = = = = = = = = = = = = = = = = = = =
3754 5200              ;
3755 5200              ;   IN:    x/a = handle.
3756 5200              ;
3757 5200              ;  OUT:    <ctlPtr = pointer (handle dereferenced).
3758 5200              ;
3759 5200              getcontrol2                             ; 
3760 5200              ;
3761 5200 85 15                 sta   <ctlPtr
3762 5202 86 17                 stx   <ctlPtr+2
3763 5204              ;
3764 5204 A0 02 00              ldy   #2
3765 5207 B7 15                 lda   [<ctlPtr],y
3766 5209 A8                    tay   
3767 520A A7 15                 lda   [<ctlPtr]
3768 520C 85 15                 sta   <ctlPtr
3769 520E 84 17                 sty   <ctlPtr+2
3770 5210 60                    rts   
3771 5211              ;
3772 5211                       ENDP 
3773 5211              ;
3774 5211              ;
3775 5211              ;            APPEND                     ALERTDEF.ASM
3776 5211                       TITLE 'Apple IIGS Window Manager                   ALERTDEF.ASM' 
3777 5211              ;
3778 5211              ;          Copyright Apple Computer, Inc. 1986-1987
3779 5211              ;          All rights reserved
3780 5211              ;          Written by Dan Oliver
3781 5211              ;
3782 5211              ;        This module contains the window definition procedure
3783 5211              ;        of a standard alert window.
3784 5211              ;
3785 5211              ;
3786 5211              ;====================================================
3787 5211              ;        Alert window definition procedure.
3788 5211              ;====================================================
3789 5211              ;
3790 5211              ;   IN:    PUSH:LONG - space for result.
3791 5211              ;          PUSH:LONG - pointer to Window Manager globals.
3792 5211              ;          PUSH:WORD - operation to perform.
3793 5211              ;          PUSH:LONG - pointer to window's port.
3794 5211              ;          PUSH:LONG - addtional parameter defined by operation.
3795 5211              ;          JSL to defProc.
3796 5211              ;
3797 5211              ;          For this defProc the direct page is the Window Manager's.
3798 5211              ;
3799 5211                       EXPORT alertDefProc 
3800 5211              alertDefProc PROC 
3801 5211              ;
3802 5211              ;
3803 5211              ; --- Set up for defProc call --------------------------------
3804 5211              ;
3805 5211 20 D2 54              jsr   startup
3806 5214              ;
3807 5214              ;
3808 5214              ; --- Dispatch to operation handler --------------------------
3809 5214              ;
3810 5214 A5 48                 lda   <operation
3811 5216 C9 0B 00              cmp   #11
3812 5219 B0 0B                 bcs   skip2
3813 521B 0A                    asl   a
3814 521C AA                    tax   
3815 521D FC 2C 52              jsr   (taskTable,x)
3816 5220 85 4E                 sta   <result
3817 5222 86 50                 stx   <result+2
3818 5224 B0 03                 bcs   skip1
3819 5226 A0 00 00     skip2    ldy   #0                       No error code.
3820 5229              ;
3821 5229              ;
3822 5229              ; --- Return to caller ---------------------------------------
3823 5229              ;
3824 5229 82 B1 02     skip1    brl   shutdown
3825 522C              ;
3826 522C              ;
3827 522C 42 52        taskTable DC W:alertDraw                0 Draw window frame.
3828 522E B4 52                 DC W:alertHit                  1 Hit test window.
3829 5230 1A 53                 DC W:alertRgns                 2 Compute struc and content regions.
3830 5232 E4 52                 DC W:alertInit                 3 Additional initailization.
3831 5234 B9 47                 DC W:docDispose                4 Additional diaposal.
3832 5236 5A 53                 DC W:alertDrag                 5 Return address of draw frame routine.
3833 5238 5A 53                 DC W:alertGrow                 6 Draw grow window outline.
3834 523A EC 47                 DC W:docRecSize                7 Return window record size.
3835 523C 2A 48                 DC W:docPosition               8 Return position and size of window.
3836 523E 37 48                 DC W:docBehind                 9 Return where window goes in list.
3837 5240 70 48                 DC W:docCallDefProc            10Generic call to defProc.
3838 5242              ;
3839 5242              ;
3840 5242              ; = = = = = = = = = = = = = = = = = = = = = = = =
3841 5242              ; 0        Draw alert window's frame.
3842 5242              ;100= = = = = = = = = = = = = = = = = = = = = = =
3843 5242              ;
3844 5242              ;   IN:    w_wind = window to draw.
3845 5242              ;          w_wrect = coordinates of entire window in local coordinates.
3846 5242              ;          justInfo = TRUE to only draw the info bar.
3847 5242              ;
3848 5242              ;  OUT:    x/a = result.
3849 5242              ;
3850 5242              alertDraw                               ; 
3851 5242              ;
3852 5242              frame    equ   w_work                   Window's frame type.
3853 5242              highlight equ   frame+2                 TRUE if this window is on top.
3854 5242              ;
3855 5242              ;
3856 5242 A0 D2 00              ldy   #wFrame
3857 5245 B7 44                 lda   [<w_wind],y
3858 5247 85 15                 sta   <frame                   For easy access.
3859 5249 29 01 00              and   #F_HILITED               Get highlight bit.
3860 524C 85 17                 sta   <highlight               Set flag.
3861 524E              ;
3862 524E 20 CE 53              jsr   setcolorptr              Set pointer to window's color table.
3863 5251              ;
3864 5251              ;
3865 5251              ; --- Set frame outline pattern/color --------------------
3866 5251              ;
3867 5251 A0 00 00              ldy   #FRAME_CLR
3868 5254 20 3D 54              jsr   setoutline               Set pen color and pattern.
3869 5257              ;
3870 5257 20 7F 54              jsr   getLocalRect             <w_rect & <w_wrect = frame RECT in local.
3871 525A              ;
3872 525A              ;
3873 525A              ; --- Draw an alert frame -----------------------------------
3874 525A              ;
3875 525A              ; ------ Draw outside frame ----------------------------------
3876 525A              ;
3877 525A 20 B1 53              jsr   pushrect                 For InsetRect call.
3878 525D              ;
3879 525D 20 76 54              jsr   getLineSize
3880 5260 1A                    inc   a                        Width = 2 in 320, 3 in 640.
3881 5261 48                    pha   
3882 5262 A0 12 00              ldy   #screenMode              640 mode?
3883 5265 B7 4A                 lda   [<globals],y
3884 5267 F0 03                 beq   ok100
3885 5269 68                    pla                            Width = 2 in 640.
3886 526A 3A                    dec   a
3887 526B 48                    pha   
3888 526C              ;
3889 526C 68           ok100    pla   
3890 526D              ;
3891 526D 48                    pha                            For InsetRect call.
3892 526E DA                    phx   
3893 526F              ;
3894 526F 48                    pha   
3895 5270 DA                    phx   
3896 5271 A2 04 2C 22           _SetPenSize 
3897 5278              ;
3898 5278 20 53 54              jsr   framerect                Draw outline around the window.
3899 527B              ;
3900 527B A2 04 4C 22           _InsetRect 
3901 5282              ;
3902 5282              ;
3903 5282              ; ------ Draw middle frame ---------------------------------------------
3904 5282              ;
3905 5282 A0 07 00              ldy   #GROW_CLR+1
3906 5285 20 3D 54              jsr   setoutline               Set pen color and pattern.
3907 5288              ;
3908 5288 20 B1 53              jsr   pushrect                 For InsetRect call.
3909 528B              ;
3910 528B 20 76 54              jsr   getLineSize
3911 528E 0A                    asl   a
3912 528F 1A                    inc   a                        Width = 3 in 320, 5 in 640.
3913 5290 E8                    inx                            Line height.
3914 5291              ;
3915 5291 48                    pha                            For InsetRect call.
3916 5292 DA                    phx   
3917 5293              ;
3918 5293 48                    pha   
3919 5294 DA                    phx   
3920 5295 A2 04 2C 22           _SetPenSize 
3921 529C              ;
3922 529C 20 53 54              jsr   framerect                Draw outline around the window.
3923 529F              ;
3924 529F A2 04 4C 22           _InsetRect 
3925 52A6              ;
3926 52A6              ;
3927 52A6              ; ------ Draw inside frame ---------------------------------------------
3928 52A6              ;
3929 52A6 A0 09 00              ldy   #INFOR_CLR+1
3930 52A9 20 3D 54              jsr   setoutline               Set pen color and pattern.
3931 52AC              ;
3932 52AC 20 53 54              jsr   framerect                Draw outline around the window.
3933 52AF              ;
3934 52AF 20 07 54              jsr   unlockColor              Leave color table unlocked.
3935 52B2 18                    clc                            No error.
3936 52B3 60                    rts   
3937 52B4              ;
3938 52B4              ;
3939 52B4              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
3940 52B4              ; 1        Test hit on a standard documnet window.
3941 52B4              ;200= = = = = = = = = = = = = = = = = = = = = = = = = = = =
3942 52B4              ;
3943 52B4              ;   IN:    <w_param = y point to check.
3944 52B4              ;          <w_param+2 = x point to check.
3945 52B4              ;
3946 52B4              ;  OUT:    a = part point is zero if no point found,
3947 52B4              ;              else a = wInContent
3948 52B4              ;                       wInDrag
3949 52B4              ;                       wInGrow
3950 52B4              ;                       wInGoAway
3951 52B4              ;                       wInZoom
3952 52B4              ;                       wInInfo
3953 52B4              ;                       wInVScroll
3954 52B4              ;                       wInHScroll
3955 52B4              ;                       wInFrame
3956 52B4              ;  OUT:    x/a = result.
3957 52B4              ;
3958 52B4              ;
3959 52B4              alertHit                                ; 
3960 52B4              ;
3961 52B4              savframe equ   w_work+4
3962 52B4              ;
3963 52B4              ;
3964 52B4 48                    pha                            Space for returned value.
3965 52B5 A9 40 00              lda   #w_param                 Pass pointer to point to check.
3966 52B8 20 64 8F              jsr   pushDpage
3967 52BB A0 C4 00              ldy   #wcontRgn+2
3968 52BE 20 B7 53              jsr   pushWindLong             Pass handle of region to check.
3969 52C1 A2 04 75 22           _PtInRgn 
3970 52C8 68                    pla                            Get result.
3971 52C9 F0 05                 beq   not_content
3972 52CB              ;
3973 52CB A9 13 00              lda   #wInContent              On content.
3974 52CE 18                    clc                            No error.
3975 52CF 60                    rts   
3976 52D0              ;
3977 52D0              ;
3978 52D0              not_content                             ; 
3979 52D0              ;
3980 52D0 A0 D2 00              ldy   #wframe                  Is there a title bar?
3981 52D3 B7 44                 lda   [<w_wind],y
3982 52D5 29 80 00              and   #F_MOVE
3983 52D8 D0 05                 bne   ok_move
3984 52DA              ;
3985 52DA A9 1B 00              lda   #wInFrame                On window frame, but no region.
3986 52DD 18                    clc                            No error.
3987 52DE 60                    rts   
3988 52DF              ;
3989 52DF A9 14 00     ok_move  lda   #wInDrag                 On title bar.
3990 52E2 18                    clc                            No error.
3991 52E3 60                    rts   
3992 52E4              ;
3993 52E4              ;
3994 52E4              ; = = = = = = = = = = = = = = = = = = = = = = = = = = =
3995 52E4              ; 3        Perform additional initialization.
3996 52E4              ;400= = = = = = = = = = = = = = = = = = = = = = = = = =
3997 52E4              ;
3998 52E4              ;   IN:    w_wrect = content area in global coordinates.
3999 52E4              ;          w_param = pointer to parameter list.
4000 52E4              ;          w_wind = window pointer.
4001 52E4              ;
4002 52E4              ;  OUT:    x/a = result.
4003 52E4              ;
4004 52E4              alertInit                               ; 
4005 52E4              ;
4006 52E4              ;
4007 52E4              ;
4008 52E4              ; --- Make sure parameter list is the proper size ------------
4009 52E4              ;
4010 52E4 A7 40                 lda   [<w_param]               Check length paramter.
4011 52E6 C9 4E 00              cmp   #p_size                  Proper size?
4012 52E9 F0 05                 beq   ok400
4013 52EB              ;
4014 52EB A0 01 0E              ldy   #$0E01                   Bad parameter list length error.
4015 52EE 38                    sec                            Error flag.
4016 52EF 60                    rts   
4017 52F0              ;
4018 52F0              ok400                                   ; 
4019 52F0              ;
4020 52F0              ;
4021 52F0              ; --- Transferr data from parameter list to window record ----
4022 52F0              ;
4023 52F0 A0 D2 00              ldy   #wframe                  Place in record to put parameter list.
4024 52F3 A2 02 00              ldx   #p_wframe
4025 52F6 5A           lop2     phy   
4026 52F7 9B                    txy   
4027 52F8 B7 40                 lda   [<w_param],y
4028 52FA 7A                    ply   
4029 52FB 17 44                 ora   [<w_wind],y              OR to not disturb wFrame bits already set.
4030 52FD 97 44                 sta   [<w_wind],y
4031 52FF C8                    iny   
4032 5300 C8                    iny   
4033 5301 E8                    inx   
4034 5302 E8                    inx   
4035 5303 E0 3A 00              cpx   #p_updateDraw
4036 5306 D0 EE                 bne   lop2
4037 5308              ;
4038 5308 A0 08 00              ldy   #p_wRefCon               Set the wRefCon field.
4039 530B A2 B4 00              ldx   #wRefCon+2
4040 530E 20 95 47              jsr   setWindField
4041 5311              ;
4042 5311 A0 3A 00              ldy   #p_updateDraw            Set the wContDraw field.
4043 5314 A2 B8 00              ldx   #wContDraw+2
4044 5317 20 95 47              jsr   setWindField
4045 531A              ;
4046 531A              ;
4047 531A              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4048 531A              ; 2        Initialize window's StructRgn and ContentRgn.
4049 531A              ;300= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4050 531A              ;
4051 531A              ;   IN:    <w_wind = window pointer.
4052 531A              ;          <globals = pointer to Window Manager's global data area.
4053 531A              ;
4054 531A              ;  OUT:    <w_wrect = trashed.
4055 531A              ;
4056 531A 20 9D 54     alertRgns jsr   getGlobalRect           w_wrect = port bounds.
4057 531D              ;
4058 531D              ;
4059 531D              ; --- Compute content region ---------------------------------
4060 531D              ;
4061 531D A0 C4 00              ldy   #wcontRgn+2              Pass handle of content region.
4062 5320 20 B7 53              jsr   pushWindLong
4063 5323 20 A7 53              jsr   pushwrect
4064 5326 A2 04 6C 22           _RectRgn 
4065 532D              ;
4066 532D              ;
4067 532D              ; --- Compute size of frame by expanding the content area ----
4068 532D              ;
4069 532D 20 A7 53              jsr   pushwrect                Common need.
4070 5330              ;
4071 5330 A2 F8 FF              ldx   #-8                      Width of vertical frame in 320 mode.
4072 5333 A0 12 00              ldy   #screenMode
4073 5336 B7 4A                 lda   [<globals],y
4074 5338 F0 03                 beq   store300
4075 533A A2 F4 FF              ldx   #-12
4076 533D DA           store300 phx   
4077 533E F4 FB FF              pea   $FFFB                    Horizontal frame height.
4078 5341 A2 04 4C 22           _InsetRect 
4079 5348              ;
4080 5348 A0 C0 00              ldy   #wstrucRgn+2             Pass handle of StructRgn.
4081 534B 20 B7 53              jsr   pushWindLong
4082 534E 20 A7 53              jsr   pushwrect                Set to global RECT in 'w_wrect'.
4083 5351 A2 04 6C 22           _RectRgn 
4084 5358              ;
4085 5358 18                    clc                            No error.
4086 5359 60                    rts   
4087 535A              ;
4088 535A              ;
4089 535A              ; = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4090 535A              ; 5        Return address of routine to draw window outline.
4091 535A              ;510= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =
4092 535A              ;
4093 535A              ;  OUT:    x/a = result, zero for default outline.
4094 535A              ;
4095 535A              alertDrag                               ; 
4096 535A              ;
4097 535A              ;
4098 535A              ; = = = = = = = = = = = = = = = = = = = = = = = =
4099 535A              ; 6        Draw grow window outline.
4100 535A              ;600= = = = = = = = = = = = = = = = = = = = = = =
4101 535A              ;
4102 535A              ;  OUT:    x/a = result.
4103 535A              ;
4104 535A              alertGrow                               ; 
4105 535A              ;
4106 535A A9 00 00              lda   #0                       Perform default action.
4107 535D AA                    tax   
4108 535E 18                    clc                            No error.
4109 535F 60                    rts   
4110 5360              ;
4111 5360                       ENDP 
4112 5360              ;
4113 5360              ;
4114 5360              ;            APPEND                     DEFUTIL.ASM
4115 5360                       TITLE 'Apple IIGS Window Manager                   DEFUTIL.ASM' 
4116 5360              ;
4117 5360              ;          Copyright Apple Computer, Inc. 1986-1987
4118 5360              ;          All rights reserved
4119 5360              ;          Written by Dan Oliver
4120 5360              ;
4121 5360              ;        This module contains routines common to standard window defProcs.
4122 5360              ;
4123 5360              ;
4124 5360              ;=====================================
4125 5360              ;        Get a region's bounds.
4126 5360              ;=====================================
4127 5360              ;
4128 5360              ;   IN:    <w_wind = window record that contain region handle.
4129 5360              ;          y = index into window for region handle.
4130 5360              ;
4131 5360              ;  OUT:    <w_wrect = bounds of region.
4132 5360              ;
4133 5360              getRgnBounds PROC 
4134 5360              ;
4135 5360                                                      ;using equates
4136 5360              ;
4137 5360 B7 44                 lda   [<w_wind],y              Get handle from window record.
4138 5362 AA                    tax   
4139 5363 C8                    iny   
4140 5364 C8                    iny   
4141 5365 B7 44                 lda   [<w_wind],y
4142 5367 80 10                 bra   enter1
4143 5369              ;
4144 5369              ;
4145 5369              ; = = = = = = = = = = = = = = = = = = = = =
4146 5369              ;          Get bounds of desktop.
4147 5369              ;100= = = = = = = = = = = = = = = = = = = =
4148 5369              ;
4149 5369                       ENTRY getDeskBounds 
4150 5369              getDeskBounds                           ;       
4151 5369              ;
4152 5369 48                    pha                            Space for result.
4153 536A 48                    pha   
4154 536B F4 02 00              pea   2                        Pass 'get desktop region' command.
4155 536E 48                    pha                            Pass parameter (not used).
4156 536F 48                    pha   
4157 5370 A2 0E 0C 22           _Desktop 
4158 5377 FA                    plx                            Get handle of desktop region.
4159 5378 68                    pla   
4160 5379              ;
4161 5379 D4 17        enter1   pei   <w_work+2                Save.
4162 537B D4 15                 pei   <w_work
4163 537D              ;
4164 537D 86 15                 stx   <w_work
4165 537F 85 17                 sta   <w_work+2
4166 5381              ;
4167 5381 A0 02 00              ldy   #2
4168 5384 B7 15                 lda   [<w_work],y
4169 5386 A8                    tay   
4170 5387 A7 15                 lda   [<w_work]
4171 5389 18                    clc   
4172 538A 69 02 00              adc   #Rgn_Bounds              I'm after the region's bounds.
4173 538D 90 01                 bcc   store1
4174 538F C8                    iny   
4175 5390 85 15        store1   sta   <w_work
4176 5392 84 17                 sty   <w_work+2                That's the pointer to bounds.
4177 5394              ;
4178 5394 A0 06 00              ldy   #x2                      Put bounds into 'w_wrect'.
4179 5397 BB           lop1     tyx   
4180 5398 B7 15                 lda   [<w_work],y
4181 539A 95 05                 sta   <w_wrect,x
4182 539C 88                    dey   
4183 539D 88                    dey   
4184 539E 10 F7                 bpl   lop1
4185 53A0              ;
4186 53A0 68                    pla                            Restore.
4187 53A1 85 15                 sta   <w_work
4188 53A3 68                    pla   
4189 53A4 85 17                 sta   <w_work+2
4190 53A6              ;
4191 53A6 60                    rts   
4192 53A7                       ENDP 
4193 53A7              ;
4194 53A7              ;
4195 53A7              ;===================================================
4196 53A7              ;        Push address of direct page location.
4197 53A7              ;===================================================
4198 53A7              ;
4199 53A7              pushwrect PROC 
4200 53A7
4201 53A7 A9 05 00              lda   #w_wrect
4202 53AA 80 08                 bra   ok1
4203 53AC              ;
4204 53AC                       ENTRY pushParam 
4205 53AC              pushParam                               ;       
4206 53AC A9 40 00              lda   #w_param
4207 53AF 80 03                 bra   ok1
4208 53B1              ;
4209 53B1                       ENTRY pushrect 
4210 53B1              pushrect                                ;       
4211 53B1 A9 0D 00              lda   #w_rect
4212 53B4 82 AD 3B     ok1      brl   pushDpage
4213 53B7                       ENDP 
4214 53B7              ;
4215 53B7              ;
4216 53B7              ;==============================================
4217 53B7              ;        Push a long from window record.
4218 53B7              ;==============================================
4219 53B7              ;
4220 53B7              ;   IN:    y = offset into window record.
4221 53B7              ;          <w_wind = pointer to window record.
4222 53B7              ;
4223 53B7              pushWindLong PROC 
4224 53B7              ;
4225 53B7                                                      ;using equates
4226 53B7              ;
4227 53B7 FA                    plx                            Get return address.
4228 53B8              ;
4229 53B8 B7 44                 lda   [<w_wind],y              Put long on stack.
4230 53BA 48                    pha   
4231 53BB 88                    dey   
4232 53BC 88                    dey   
4233 53BD B7 44                 lda   [<w_wind],y
4234 53BF 48                    pha   
4235 53C0              ;
4236 53C0 DA                    phx                            Put return address back on stack.
4237 53C1 60                    rts   
4238 53C2                       ENDP 
4239 53C2              ;
4240 53C2              ;
4241 53C2              ;========================================
4242 53C2              ;        Move 'w_wrect' into 'w_rect'
4243 53C2              ;========================================
4244 53C2              ;
4245 53C2              ;   IN:    <w_wrect = RECT to clone.
4246 53C2              ;
4247 53C2              ;  OUT:    <w_rect = clone of <w_wrect.
4248 53C2              ;
4249 53C2              cloneRect PROC 
4250 53C2              ;
4251 53C2                                                      ;using equates
4252 53C2              ;
4253 53C2 A2 06 00              ldx   #x2
4254 53C5 B5 05        lop      lda   <w_wrect,x
4255 53C7 95 0D                 sta   <w_rect,x
4256 53C9 CA                    dex   
4257 53CA CA                    dex   
4258 53CB 10 F8                 bpl   lop
4259 53CD 60                    rts   
4260 53CE                       ENDP 
4261 53CE              ;
4262 53CE              ;
4263 53CE              ;====================================================
4264 53CE              ;          Set window's color table pointer.
4265 53CE              ;====================================================
4266 53CE              ;
4267 53CE              ;   IN:    w_wind = pointer to window.
4268 53CE              ;
4269 53CE              ;  OUT:    <windColors = pointer to color table.
4270 53CE              ;
4271 53CE              setcolorptr PROC 
4272 53CE              ;
4273 53CE A0 E4 00              ldy   #wcolor                  Fetch color table field from window record.
4274 53D1 B7 44                 lda   [<w_wind],y
4275 53D3 AA                    tax   
4276 53D4 C8                    iny   
4277 53D5 C8                    iny   
4278 53D6 B7 44                 lda   [<w_wind],y
4279 53D8 30 11                 bmi   @handle                  Is the color table a handle?
4280 53DA D0 26                 bne   @store1                  Is the color table a pointer?
4281 53DC 9B                    txy   
4282 53DD D0 23                 bne   @store1
4283 53DF              ;
4284 53DF              ;
4285 53DF              ; --- NIL color table, use default.
4286 53DF              ;
4287 53DF A0 0A 00              ldy   #defWindClr              Use default color table.
4288 53E2 B7 4A                 lda   [<globals],y
4289 53E4 AA                    tax   
4290 53E5 C8                    iny   
4291 53E6 C8                    iny   
4292 53E7 B7 4A                 lda   [<globals],y
4293 53E9 10 17                 bpl   @store1                  Is default a pointer?
4294 53EB              ;
4295 53EB              ;
4296 53EB              ; --- Handle for color table.
4297 53EB              ;
4298 53EB 86 01        @handle  stx   <windColors              Store handle.
4299 53ED 85 03                 sta   <windColors+2
4300 53EF              ;
4301 53EF A0 04 00              ldy   #4                       Lock the color table.
4302 53F2 B7 01                 lda   [<windColors],y
4303 53F4 09 00 80              ora   #$8000
4304 53F7 97 01                 sta   [<windColors],y
4305 53F9 88                    dey                            Dereference the color table.
4306 53FA 88                    dey   
4307 53FB B7 01                 lda   [<windColors],y
4308 53FD 48                    pha   
4309 53FE A7 01                 lda   [<windColors]
4310 5400 AA                    tax   
4311 5401 68                    pla   
4312 5402              ;
4313 5402 86 01        @store1  stx   <windColors
4314 5404 85 03                 sta   <windColors+2
4315 5406 60                    rts   
4316 5407                       ENDP 
4317 5407              ;
4318 5407              ;
4319 5407              ;====================================================
4320 5407              ;          Unlock window's color table.
4321 5407              ;====================================================
4322 5407              ;
4323 5407              ;   IN:    <w_wind = pointer to window.
4324 5407              ;
4325 5407              ;  OUT:    Color table unlocked if it is a handle.  This includes the default table.
4326 5407              ;
4327 5407              unlockColor PROC 
4328 5407              ;
4329 5407 A0 E4 00              ldy   #wcolor                  Fetch color table field from window record.
4330 540A B7 44                 lda   [<w_wind],y
4331 540C AA                    tax   
4332 540D C8                    iny   
4333 540E C8                    iny   
4334 540F B7 44                 lda   [<w_wind],y
4335 5411 30 11                 bmi   @handle                  Is the color table a handle?
4336 5413 D0 27                 bne   @exit                    Is the color table a pointer?
4337 5415 9B                    txy   
4338 5416 D0 24                 bne   @exit                    If a pointer, nothing to unclock.
4339 5418              ;
4340 5418              ;
4341 5418              ; --- NIL color table, unlock default.
4342 5418              ;
4343 5418 A0 0A 00              ldy   #defWindClr              Use default color table.
4344 541B B7 4A                 lda   [<globals],y
4345 541D AA                    tax   
4346 541E C8                    iny   
4347 541F C8                    iny   
4348 5420 B7 4A                 lda   [<globals],y
4349 5422 10 18                 bpl   @exit                    Is default a pointer?  If yes, nothing to unlock.
4350 5424              ;
4351 5424              ;
4352 5424              ; --- Handle for color table.
4353 5424              ;
4354 5424 D4 17        @handle  pei   <w_work+2                Save.
4355 5426 D4 15                 pei   <w_work
4356 5428              ;
4357 5428 85 15                 sta   <w_work                  Store handle.
4358 542A 86 17                 stx   <w_work+2
4359 542C              ;
4360 542C A0 04 00              ldy   #4                       Unlock the color table.
4361 542F B7 15                 lda   [<w_work],y
4362 5431 29 FF 7F              and   #$7FFF
4363 5434 97 15                 sta   [<w_work],y
4364 5436              ;
4365 5436 68                    pla                            Restore.
4366 5437 85 15                 sta   <w_work
4367 5439 68                    pla   
4368 543A 85 17                 sta   <w_work+2
4369 543C              ;
4370 543C 60           @exit    rts   
4371 543D                       ENDP 
4372 543D              ;
4373 543D              ;
4374 543D              ;================================================
4375 543D              ;        Set pen to a pattern and color.
4376 543D              ;================================================
4377 543D              ;
4378 543D              ;   IN:    y = offset into color table to get pattern/color.
4379 543D              ;          <w_wind = pointer to window.
4380 543D              ;          <windColors = pointer to color table.
4381 543D              ;
4382 543D                       EXPORT setoutline 
4383 543D              setoutline PROC 
4384 543D
4385 543D B7 01                 lda   [<windColors],y
4386 543F 29 F0 00              and   #$00F0                   Solid color for line only.
4387 5442 0A                    asl   a
4388 5443 18                    clc   
4389 5444 69 F6 40              adc   #colorBlack              Compute address of solid color.
4390 5447
4391 5447 F4 FD 00              pea   colorBlack>>16           Pass pointer to pattern.
4392 544A 48                    pha   
4393 544B A2 04 30 22           _SetPenPat                     Set Pen Pattern.
4394 5452 60                    rts   
4395 5453                       ENDP 
4396 5453
4397 5453
4398 5453              ;==================================
4399 5453              ;          Frame a RECT.
4400 5453              ;==================================
4401 5453              ;
4402 5453              ;  IN:     <w_rect = RECT to draw and frame.
4403 5453              ;          Pen set to pattern.
4404 5453              ;
4405 5453              framerect PROC 
4406 5453              ;
4407 5453 20 B1 53              jsr   pushrect                 Pass address of 'w_rect'.
4408 5456 A2 04 53 22           _FrameRect 
4409 545D 60                    rts   
4410 545E                       ENDP 
4411 545E              ;
4412 545E              ;
4413 545E              ;=================================================
4414 545E              ;          Push pointer to current port.
4415 545E              ;=================================================
4416 545E              ;
4417 545E              ;   IN:    Nothing.
4418 545E              ;
4419 545E              ;  OUT:    PUSH:LONG - pointer to current port.
4420 545E              ;
4421 545E              pushPort PROC 
4422 545E              ;
4423 545E 48                    pha                            Space for result.
4424 545F 48                    pha   
4425 5460 A2 04 1C 22           _GetPort                       Get current port.
4426 5467 68                    pla   
4427 5468 FA                    plx   
4428 5469              ;
4429 5469 7A                    ply                            Get return address.
4430 546A              ;
4431 546A DA                    phx                            Push current port.
4432 546B 48                    pha   
4433 546C              ;
4434 546C 5A                    phy                            Put return address back.
4435 546D 60                    rts   
4436 546E                       ENDP 
4437 546E              ;
4438 546E              ;
4439 546E              ;================================
4440 546E              ;          Push line size.
4441 546E              ;================================
4442 546E              ;
4443 546E              ;   IN:    <globals = pointer to Window Manager's global data area.
4444 546E              ;
4445 546E              ;  OUT:    PUSH:WORD - width of lines.
4446 546E              ;          PUSH:WORD - height of lines.
4447 546E              ;
4448 546E              pushLineSize PROC 
4449 546E
4450 546E 20 76 54              jsr   getLineSize              a = width, x = height.
4451 5471              ;
4452 5471 7A                    ply                            Get return address.
4453 5472              ;
4454 5472 48                    pha                            Push width.
4455 5473 DA                    phx                            Push height.
4456 5474              ;
4457 5474 5A                    phy                            Put return address back.
4458 5475 60                    rts   
4459 5476                       ENDP 
4460 5476              ;
4461 5476              ;
4462 5476              ;===================================
4463 5476              ;          Get size of lines.
4464 5476              ;===================================
4465 5476              ;
4466 5476              ;   IN:    <globals = pointer to Window Manager's global data area.
4467 5476              ;
4468 5476              ;  OUT:    a = width of lines.
4469 5476              ;          x = height of lines.
4470 5476              ;
4471 5476              getLineSize PROC 
4472 5476
4473 5476 A0 00 00              ldy   #lineW
4474 5479 B7 4A                 lda   [<globals],y             Return width in a.
4475 547B A2 01 00              ldx   #1                       Return height in x.
4476 547E 60                    rts   
4477 547F                       ENDP 
4478 547F              ;
4479 547F              ;
4480 547F              ;====================================================
4481 547F              ;          Get bounds of window's strucRgn.
4482 547F              ;====================================================
4483 547F              ;
4484 547F              ;   IN:    <w_wind = pointer to window.
4485 547F              ;
4486 547F              ;  OUT:    <w_wrect = bounds of window's strucRgn in local.
4487 547F              ;          <w_rect = bounds of window's strucRgn in local.
4488 547F              ;          <w_work = trash.
4489 547F              ;
4490 547F              getLocalRect PROC 
4491 547F
4492 547F A0 BE 00              ldy   #wStrucRgn               Fetch window's strucRgn handle.
4493 5482 20 60 53              jsr   getRgnBounds             <w_wrect = bounds of strucRgn in global.
4494 5485 20 C2 53              jsr   cloneRect                <w_rect = <w_wrect.
4495 5488              ;
4496 5488              ;
4497 5488              ; = = = = = = = = = = = = = = = = = = = = =
4498 5488              ;          Convert <w_wrect to local.
4499 5488              ;100= = = = = = = = = = = = = = = = = = = =
4500 5488              ;
4501 5488              ;   IN:    <w_wrect = RECT.
4502 5488              ;
4503 5488              ;  OUT:    <w_wrect = local (where y1,x1 are now 0,0)
4504 5488              ;          <w_rect = clone of <w_wrect.
4505 5488              ;
4506 5488                       ENTRY makeRectLocal 
4507 5488              makeRectLocal                           ;       
4508 5488              ;
4509 5488 A2 02 00              ldx   #x1
4510 548B B5 11        lop100   lda   <w_rect+y2,x
4511 548D 38                    sec   
4512 548E F5 0D                 sbc   <w_rect+y1,x
4513 5490 95 11                 sta   <w_rect+y2,x
4514 5492 95 09                 sta   <w_wrect+y2,x
4515 5494 74 0D                 stz   <w_rect+y1,x
4516 5496 74 05                 stz   <w_wrect+y1,x
4517 5498 CA                    dex   
4518 5499 CA                    dex   
4519 549A 10 EF                 bpl   lop100
4520 549C              ;
4521 549C 60                    rts   
4522 549D                       ENDP 
4523 549D              ;
4524 549D              ;
4525 549D              ;==========================================================
4526 549D              ;          Get global coordinates of window port.
4527 549D              ;==========================================================
4528 549D              ;
4529 549D              ;   IN:    w_wind = pointer to window record.
4530 549D              ;
4531 549D              ;  OUT:    w_wrect = RECT of window grafPort in global.
4532 549D              ;
4533 549D              getGlobalRect PROC 
4534 549D
4535 549D A0 14 00              ldy   #wport+GP_PortRect+y1
4536 54A0 B7 44                 lda   [<w_wind],y
4537 54A2 A0 0C 00              ldy   #wport+boundsRect+y1
4538 54A5 38                    sec   
4539 54A6 F7 44                 sbc   [<w_wind],y
4540 54A8 85 05                 sta   <w_wrect+y1
4541 54AA              ;
4542 54AA A0 16 00              ldy   #wport+GP_PortRect+x1
4543 54AD B7 44                 lda   [<w_wind],y
4544 54AF A0 0E 00              ldy   #wport+boundsRect+x1
4545 54B2 38                    sec   
4546 54B3 F7 44                 sbc   [<w_wind],y
4547 54B5 85 07                 sta   <w_wrect+x1
4548 54B7              ;
4549 54B7 A0 18 00              ldy   #wport+GP_PortRect+y2
4550 54BA B7 44                 lda   [<w_wind],y
4551 54BC A0 0C 00              ldy   #wport+boundsRect+y1
4552 54BF 38                    sec   
4553 54C0 F7 44                 sbc   [<w_wind],y
4554 54C2 85 09                 sta   <w_wrect+y2
4555 54C4              ;
4556 54C4 A0 1A 00              ldy   #wport+GP_PortRect+x2
4557 54C7 B7 44                 lda   [<w_wind],y
4558 54C9 A0 0E 00              ldy   #wport+boundsRect+x1
4559 54CC 38                    sec   
4560 54CD F7 44                 sbc   [<w_wind],y
4561 54CF 85 0B                 sta   <w_wrect+x2
4562 54D1              ;
4563 54D1 60                    rts   
4564 54D2                       ENDP 
4565 54D2              ;
4566 54D2              ;
4567 54D2              ;=================================================================
4568 54D2              ;          Allocate a stack based direct page for defProc.
4569 54D2              ;=================================================================
4570 54D2              ;
4571 54D2              startup  PROC 
4572 54D2
4573 54D2 FA                    plx                            Get return address.
4574 54D3              ;
4575 54D3 0B                    phd                            Save caller's direct page.
4576 54D4              ;
4577 54D4 3B                    tsc                            Allocate direct page.
4578 54D5 38                    sec   
4579 54D6 E9 3A 00              sbc   #DIRECTSIZE
4580 54D9 1B                    tcs   
4581 54DA 5B                    tcd   
4582 54DB              ;
4583 54DB DA                    phx                            Put return address back on stack.
4584 54DC 60                    rts   
4585 54DD                       ENDP 
4586 54DD              ;
4587 54DD              ;
4588 54DD              ;==============================================================
4589 54DD              ;          Strip input parameters and exit defProc call.
4590 54DD              ;==============================================================
4591 54DD              ;
4592 54DD              shutdown PROC 
4593 54DD
4594 54DD A6 3B                 ldx   <saveDpage
4595 54DF              ;
4596 54DF A5 3E                 lda   <returnAddr+1
4597 54E1 85 4C                 sta   <returnAddr+15
4598 54E3 A5 3D                 lda   <returnAddr
4599 54E5 85 4B                 sta   <returnAddr+14
4600 54E7              ;
4601 54E7 3B                    tsc   
4602 54E8 18                    clc   
4603 54E9 69 4A 00              adc   #DIRECTSIZE+16
4604 54EC 1B                    tcs   
4605 54ED              ;
4606 54ED 8A                    txa                            Restore caller's direct page pointer.
4607 54EE 5B                    tcd   
4608 54EF              ;
4609 54EF 98                    tya                            Return error code in A.
4610 54F0 C9 01 00              cmp   #1                       Set carry if error.
4611 54F3 6B                    rtl   
4612 54F4                       ENDP 
4613 54F4              ;
4614 54F4              ;
4615 54F4              ;=====================================================================
4616 54F4              ;                   Push pointer to window's title.
4617 54F4              ;=====================================================================
4618 54F4              ;
4619 54F4              ;   IN: <w_wind = pointer to window.
4620 54F4              ;
4621 54F4              ;  OUT: Window title pointer on stack, handle locked.
4622 54F4              ;       Call unlockTitle when done.
4623 54F4              ;
4624 54F4              pushWindTitle PROC 
4625 54F4              ;
4626 54F4 A0 D6 00              ldy   #wTitle+2                Is title a handle?
4627 54F7 B7 44                 lda   [<w_wind],y
4628 54F9 10 28                 bpl   @justPush
4629 54FB              ;
4630 54FB D4 17                 pei   <w_work+2                Save.
4631 54FD D4 15                 pei   <w_work
4632 54FF              ;
4633 54FF 85 17                 sta   <w_work+2
4634 5501 88                    dey   
4635 5502 88                    dey   
4636 5503 B7 44                 lda   [<w_wind],y
4637 5505 85 15                 sta   <w_work
4638 5507              ;
4639 5507 A0 04 00              ldy   #4                       Lock the title.
4640 550A B7 15                 lda   [<w_work],y
4641 550C 09 00 80              ora   #$8000
4642 550F 97 15                 sta   [<w_work],y
4643 5511 88                    dey                            Get title pointer.
4644 5512 88                    dey   
4645 5513 B7 15                 lda   [<w_work],y
4646 5515 A8                    tay   
4647 5516 A7 15                 lda   [<w_work]
4648 5518              ;
4649 5518 FA                    plx                            Restore.
4650 5519 86 15                 stx   <w_work
4651 551B FA                    plx   
4652 551C 86 17                 stx   <w_work+2
4653 551E FA                    plx                            Get return address.
4654 551F 5A                    phy                            Push title pointer on stack.
4655 5520 48                    pha   
4656 5521 DA                    phx                            Put return address back.
4657 5522 60                    rts   
4658 5523              ;
4659 5523 82 91 FE     @justPush brl   pushWindLong            Push title pointer directly from window record.
4660 5526                       ENDP 
4661 5526              ;
4662 5526              ;
4663 5526              ;================================================================
4664 5526              ;                   Unlock window title handle.
4665 5526              ;================================================================
4666 5526              ;
4667 5526              ;   IN: <w_wind = pointer to window.
4668 5526              ;
4669 5526              ;  OUT: Window title handle unlocked if it is a handle.
4670 5526              ;
4671 5526              unlockTitle PROC 
4672 5526              ;
4673 5526 A0 D6 00              ldy   #wTitle+2                Is title a handle?
4674 5529 B7 44                 lda   [<w_wind],y
4675 552B 10 1C                 bpl   @exit
4676 552D              ;
4677 552D D4 17                 pei   <w_work+2                Save.
4678 552F D4 15                 pei   <w_work
4679 5531              ;
4680 5531 85 17                 sta   <w_work+2
4681 5533 88                    dey   
4682 5534 88                    dey   
4683 5535 B7 44                 lda   [<w_wind],y
4684 5537 85 15                 sta   <w_work
4685 5539              ;
4686 5539 A0 04 00              ldy   #4                       Unlock the title.
4687 553C B7 15                 lda   [<w_work],y
4688 553E 29 FF 7F              and   #$7FFF
4689 5541 97 15                 sta   [<w_work],y
4690 5543              ;
4691 5543 FA                    plx                            Restore.
4692 5544 86 15                 stx   <w_work
4693 5546 FA                    plx   
4694 5547 86 17                 stx   <w_work+2
4695 5549
4696 5549 60           @exit    rts   
4697 554A                       ENDP 
4698 554A              ;
4699 554A                       END   
